% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svyafc.R
\name{svyafc}
\alias{svyafc}
\alias{svyafc.survey.design}
\alias{svyafc.svyrep.design}
\alias{svyafc.DBIsvydesign}
\title{Alkire-Foster multidimensional poverty class}
\usage{
svyafc(formula, design, ...)

\method{svyafc}{survey.design}(formula, design, k, g, cutoffs, dimw = NULL, na.rm = FALSE, ...)

\method{svyafc}{svyrep.design}(formula, design, k, g, cutoffs, dimw = NULL, na.rm = FALSE, ...)

\method{svyafc}{DBIsvydesign}(formula, design, ...)
}
\arguments{
\item{formula}{a formula specifying the variables. Variables can be numeric or ordered factors.}

\item{design}{a design object of class \code{survey.design} or class \code{svyrep.design} from the \code{survey} library.}

\item{...}{future expansion}

\item{k}{a scalar defining the multidimensional cutoff.}

\item{g}{a scalar defining the exponent of the indicator.}

\item{cutoffs}{a list defining each variable's deprivation limit.}

\item{dimw}{a vector defining the weight of each dimension in the multidimensional deprivation sum.}

\item{na.rm}{Should cases with missing values be dropped?}
}
\value{
Object of class "\code{cvystat}", which are vectors with a "\code{var}" attribute giving the variance and a "\code{statistic}" attribute giving the name of the statistic.
}
\description{
Estimate indices from the Alkire-Foster class, a class of poverty measures.
}
\details{
you must run the \code{convey_prep} function on your survey design object immediately after creating it with the \code{svydesign} or \code{svrepdesign} function.
}
\examples{
library(survey)
library(laeken)
data(eusilc) ; names( eusilc ) <- tolower( names( eusilc ) )

# linearized design
des_eusilc <- svydesign( ids = ~rb030 , strata = ~db040 ,  weights = ~rb050 , data = eusilc )
des_eusilc <- convey_prep(des_eusilc)
des_eusilc <- update(des_eusilc, pb220a = ordered( pb220a ) )

# replicate-weighted design
des_eusilc_rep <- as.svrepdesign( des_eusilc , type = "bootstrap" )
des_eusilc_rep <- convey_prep(des_eusilc_rep)

# cutoffs
cos <- list( 10000, 5000 )

# variables without missing values
svyafc( ~ eqincome + hy050n , design = des_eusilc , k = .5 , g = 0, cutoffs = cos )
svyafc( ~ eqincome + hy050n , design = des_eusilc_rep , k = .5 , g = 0, cutoffs = cos )

# subsetting:
sub_des_eusilc <- subset( des_eusilc, db040 == "Styria")
sub_des_eusilc_rep <- subset( des_eusilc_rep, db040 == "Styria")

svyafc( ~ eqincome + hy050n , design = sub_des_eusilc , k = .5, g = 0, cutoffs = cos )
svyafc( ~ eqincome + hy050n , design = sub_des_eusilc_rep , k = .5, g = 0, cutoffs = cos )

\dontrun{

# including factor variable with missings
cos <- list( 10000, 5000, "EU" )
svyafc(~eqincome+hy050n+pb220a, des_eusilc, k = .5, g = 0, cutoffs = cos , na.rm = FALSE )
svyafc(~eqincome+hy050n+pb220a, des_eusilc, k = .5, g = 0, cutoffs = cos , na.rm = TRUE )
svyafc(~eqincome+hy050n+pb220a, des_eusilc_rep, k = .5, g = 0, cutoffs = cos , na.rm = FALSE )
svyafc(~eqincome+hy050n+pb220a, des_eusilc_rep, k = .5, g = 0, cutoffs = cos , na.rm = TRUE )

# database-backed design
library(RSQLite)
library(DBI)
dbfile <- tempfile()
conn <- dbConnect( RSQLite::SQLite() , dbfile )
dbWriteTable( conn , 'eusilc' , eusilc )

dbd_eusilc <-
	svydesign(
		ids = ~rb030 ,
		strata = ~db040 ,
		weights = ~rb050 ,
		data="eusilc",
		dbname=dbfile,
		dbtype="SQLite"
	)

dbd_eusilc <- convey_prep( dbd_eusilc )
dbd_eusilc <- update( dbd_eusilc, pb220a = ordered( pb220a ) )

# cutoffs
cos <- list( 10000 , 5000 )

# variables without missing values
svyafc(~eqincome+hy050n, design = dbd_eusilc, k = .5, g = 0, cutoffs = cos )

# subsetting:
sub_dbd_eusilc <- subset( dbd_eusilc, db040 == "Styria")
svyafc(~eqincome+hy050n, design = sub_dbd_eusilc, k = .5, g = 0, cutoffs = cos )

# cutoffs
cos <- list( 10000, 5000, "EU" )

# including factor variable with missings
svyafc(~eqincome+hy050n+pb220a, dbd_eusilc, k = .5, g = 0, cutoffs = cos , na.rm = FALSE )
svyafc(~eqincome+hy050n+pb220a, dbd_eusilc, k = .5, g = 0, cutoffs = cos , na.rm = TRUE )

dbRemoveTable( conn , 'eusilc' )

dbDisconnect( conn , shutdown = TRUE )

}

}
\references{
Sabina Alkire and James Foster (2011). Counting and multidimensional poverty measurement.
Journal of Public Economics, v. 95, n. 7-8, August 2011, pp. 476-487, ISSN 0047-2727.
<doi:10.1016/j.jpubeco.2010.11.006>

Alkire et al. (2015). Multidimensional Poverty Measurement and Analysis. Oxford University Press, 2015.

Daniele Pacifico and Felix Poege (2016). MPI: Stata module to compute the Alkire-Foster multidimensional poverty measures and their decomposition by deprivation indicators and population sub-groups.
URL \url{https://econpapers.repec.org/RePEc:boc:bocode:s458120}.
}
\seealso{
\code{\link{svyfgt}}
}
\author{
Guilherme Jacob, Djalma Pessoa and Anthony Damico
}
\keyword{survey}
