% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svyrenyi.R
\name{svyrenyi}
\alias{svyrenyi}
\alias{svyrenyi.DBIsvydesign}
\alias{svyrenyi.survey.design}
\alias{svyrenyi.svyrep.design}
\title{Renyi divergence measure}
\usage{
svyrenyi(formula, design, ...)

\method{svyrenyi}{survey.design}(formula, design, epsilon = 1,
  na.rm = FALSE, ...)

\method{svyrenyi}{svyrep.design}(formula, design, epsilon = 1,
  na.rm = FALSE, ...)

\method{svyrenyi}{DBIsvydesign}(formula, design, ...)
}
\arguments{
\item{formula}{a formula specifying the income variable}

\item{design}{a design object of class \code{survey.design} or class \code{svyrep.design} from the \code{survey} library.}

\item{...}{future expansion}

\item{epsilon}{a parameter that determines the sensivity towards inequality on the top of the distribution. Defaults to epsilon = 1.}

\item{na.rm}{Should cases with missing values be dropped?}
}
\value{
Object of class "\code{cvystat}", which are vectors with a "\code{var}" attribute giving the variance and a "\code{statistic}" attribute giving the name of the statistic.
}
\description{
Estimate the Renyi divergence measure, a measure of inequality
}
\details{
you must run the \code{convey_prep} function on your survey design object immediately after creating it with the \code{svydesign} or \code{svrepdesign} function.

If \code{epsilon == 1}, the result matches \code{svygei} with \code{epsilon == 1}. As in the generalized entropy index, when \code{epsilon == 1}, the logarithm in the function only allows for strictly positive variables.
}
\examples{
library(survey)
library(vardpoor)
data(eusilc) ; names( eusilc ) <- tolower( names( eusilc ) )

# linearized design
des_eusilc <- svydesign( ids = ~rb030 , strata = ~db040 ,  weights = ~rb050 , data = eusilc )
des_eusilc <- convey_prep(des_eusilc)

svyrenyi( ~eqincome , design = des_eusilc, epsilon = .5 )

# replicate-weighted design
des_eusilc_rep <- as.svrepdesign( des_eusilc , type = "bootstrap" )
des_eusilc_rep <- convey_prep(des_eusilc_rep)

svyrenyi( ~eqincome , design = des_eusilc_rep, epsilon = .5 )

# linearized design using a variable with missings
svyrenyi( ~py010n , design = des_eusilc, epsilon = .5 )
svyrenyi( ~py010n , design = des_eusilc, epsilon = .5, na.rm = TRUE )
# replicate-weighted design using a variable with missings
svyrenyi( ~py010n , design = des_eusilc_rep, epsilon = .5 )
svyrenyi( ~py010n , design = des_eusilc_rep, epsilon = .5, na.rm = TRUE )


# library(MonetDBLite) is only available on 64-bit machines,
# so do not run this block of code in 32-bit R
\dontrun{

# database-backed design
library(MonetDBLite)
library(DBI)
dbfolder <- tempdir()
conn <- dbConnect( MonetDBLite::MonetDBLite() , dbfolder )
dbWriteTable( conn , 'eusilc' , eusilc )

dbd_eusilc <-
	svydesign(
		ids = ~rb030 ,
		strata = ~db040 , 
		weights = ~rb050 ,
		data="eusilc",
		dbname=dbfolder,
		dbtype="MonetDBLite"
	)

dbd_eusilc <- convey_prep( dbd_eusilc )

svyrenyi( ~eqincome , design = dbd_eusilc, epsilon = .5 )

# Testing if Renyi and GEI match when epsilon == 1:
svyrenyi( ~eqincome , design = subset(dbd_eusilc, eqincome > 0 ), epsilon = 1 )
svygei( ~eqincome , design = subset(dbd_eusilc, eqincome > 0 ), epsilon = 1 )

dbRemoveTable( conn , 'eusilc' )

}

}
\author{
Guilherme Jacob, Djalma Pessoa and Anthony Damico
}
\references{
Matti Langel (2012). Measuring inequality in finite population sampling.
PhD thesis: Universite de Neuchatel,
URL \url{https://doc.rero.ch/record/29204/files/00002252.pdf}.
}
\seealso{
\code{\link{svygei}}
}
\keyword{survey}

