% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svygpg.R
\name{svygpg}
\alias{svygpg}
\alias{svygpg.DBIsvydesign}
\alias{svygpg.survey.design}
\alias{svygpg.svyrep.design}
\title{Linearization of the gender pay (wage) gap}
\usage{
svygpg(formula, design, ...)

\method{svygpg}{survey.design}(formula, design, sex, na.rm = FALSE, ...)

\method{svygpg}{svyrep.design}(formula, design, sex, na.rm = FALSE, ...)

\method{svygpg}{DBIsvydesign}(formula, design, sex, ...)
}
\arguments{
\item{formula}{a formula specifying the gross hourly earnings variable}

\item{design}{a design object of class \code{survey.design} or class \code{svyrep.design} from the \code{survey} library.}

\item{...}{future expansion}

\item{sex}{formula with a factor with labels 'male' and 'female'}

\item{na.rm}{Should cases with missing values be dropped?}
}
\value{
Object of class "\code{cvystat}", which are vectors with a "\code{var}" attribute giving the variance and a "\code{statistic}" attribute giving the name of the statistic.
}
\description{
Estimate the difference between the average gross hourly earnings of men and women expressed as a percentage of the average gross hourly earnings of men.
}
\details{
you must run the \code{convey_prep} function on your survey design object immediately after creating it with the \code{svydesign} or \code{svrepdesign} function.
}
\examples{
library(vardpoor)
library(survey)
data(ses)
names( ses ) <- gsub( "size" , "size_" , tolower( names( ses ) ) )
des_ses <- svydesign(id=~1, weights=~weights, data=ses)
des_ses <- convey_prep(des_ses)

# linearized design
svygpg(~earningshour, des_ses, ~sex)
# replicate-weighted design
des_ses_rep <-  as.svrepdesign( des_ses , type = "bootstrap" )
des_ses_rep <- convey_prep(des_ses_rep)

svygpg(~earningshour, des_ses_rep, ~sex)


# library(MonetDBLite) is only available on 64-bit machines,
# so do not run this block of code in 32-bit R
\dontrun{

# database-backed design
library(MonetDBLite)
library(DBI)
dbfolder <- tempdir()
conn <- dbConnect( MonetDBLite::MonetDBLite() , dbfolder )
dbWriteTable( conn , 'ses' , ses )

dbd_ses <- svydesign(id=~1, weights=~weights, data="ses", dbname=dbfolder, dbtype="MonetDBLite")
dbd_ses <- convey_prep( dbd_ses )

svygpg(formula=~earningshour, design=dbd_ses, sex= ~sex)

dbRemoveTable( conn , 'ses' )

}

}
\author{
Djalma Pessoa and Anthony Damico
}
\references{
Guillaume Osier (2009). Variance estimation for complex indicators
of poverty and inequality. \emph{Journal of the European Survey Research
Association}, Vol.3, No.3, pp. 167-195,
ISSN 1864-3361, URL \url{http://ojs.ub.uni-konstanz.de/srm/article/view/369}.

Jean-Claude Deville (1999). Variance estimation for complex statistics and estimators:
linearization and residual techniques. Survey Methodology, 25, 193-203,
URL \url{http://www5.statcan.gc.ca/bsolc/olc-cel/olc-cel?lang=eng&catno=12-001-X19990024882}.
}
\seealso{
\code{\link{svyarpt}}
}
\keyword{survey}

