% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Wilson_score_CI_1x2.R
\name{Wilson_score_CI_1x2}
\alias{Wilson_score_CI_1x2}
\title{The Wilson score confidence interval}
\usage{
Wilson_score_CI_1x2(X, n, alpha = 0.05)
}
\arguments{
\item{X}{the number of successes}

\item{n}{the total number of observations}

\item{alpha}{the nominal level, e.g. 0.05 for 95\% CIs}
}
\value{
An object of the \link{contingencytables_result} class,
basically a subclass of \code{\link[base:list]{base::list()}}. Use the \code{\link[utils:str]{utils::str()}} function
to see the specific elements returned.
}
\description{
The Wilson score confidence interval
}
\examples{
# birth order 1, Singh et al. (2010)
Wilson_score_CI_1x2(singh_2010["1st", "X"], singh_2010["1st", "n"])
# birth order 2, Singh et al. (2010)
Wilson_score_CI_1x2(singh_2010["2nd", "X"], singh_2010["2nd", "n"])
# birth order 3, Singh et al. (2010)
Wilson_score_CI_1x2(singh_2010["3rd", "X"], singh_2010["3rd", "n"])
# birth order 4, Singh et al. (2010)
with(singh_2010["4th", ], Wilson_score_CI_1x2(X, n)) # alternative syntax
# Ligarden (2010)
Wilson_score_CI_1x2(ligarden_2010["X"], ligarden_2010["n"])
}
\references{
Reference Wilson EB (1927) Probable inference, the law of
succession, and statistical inference. Journal of the American Statistical
Association 22209-212
}
