set.seed(3755232)

context("Output class, name and length")

# Common elements ======================================== #

n <- matrix(c(9, 4, 4, 10), nrow = 2, byrow = TRUE)
n2 <- rbind(c(596, 18, 6, 5), c(0, 2, 0, 0), c(0, 0, 42, 0), c(11, 0, 0, 0))
n3 <- rbind(c(14, 10, 3, 2), c(11, 7, 8, 4))
n4 <- array(c(c(647, 2, 622, 27), c(41, 19, 28, 32)), dim = c(2, 2, 2))
n5 <- matrix(1:9, 3)
n6 <- matrix(1:8, ncol = 2)
n7 <- floor(matrix(c(14, 10, 3, 2, 11, 7, 8, 4), nrow = 2, byrow = TRUE) / 4)

# Unit tests ============================================= #
set.seed(6492798) # useful for functions using Bootstrap
t001 <- Adjusted_inv_sinh_CI_OR_2x2(n, printresults = FALSE)
t002 <- Adjusted_inv_sinh_CI_ratio_2x2(n, printresults = FALSE)
t003 <- Adjusted_log_CI_2x2(n, printresults = FALSE)
t004 <- AgrestiCaffo_CI_2x2(n, printresults = FALSE)
t005 <- AgrestiCoull_CI_1x2(33, 45, printresults = FALSE)
t006 <- BaptistaPike_exact_conditional_CI_2x2(n, printresults = FALSE)
t007 <- BaptistaPike_midP_CI_2x2(n, printresults = FALSE)
t008 <- Bhapkar_test_paired_cxc(n2, printresults = FALSE)
t009 <- Blaker_exact_CI_1x2(13, 16, printresults = FALSE)
t010 <- Blaker_exact_test_1x2(13, 16, .5, printresults = FALSE)
t011 <- Blaker_midP_CI_1x2(13, 16, printresults = FALSE)
t012 <- Arcsine_CI_1x2(13, 16, printresults = FALSE)
t013 <- Blaker_midP_test_1x2(13, 16, .5, printresults = FALSE)
t014 <- BonettPrice_hybrid_Wilson_score_CI_CC_paired_2x2(n, printresults = FALSE)
t015 <- BonettPrice_hybrid_Wilson_score_CI_paired_2x2(n, printresults = FALSE)
t016 <- Bonferroni_type_CIs_paired_cxc(n, printresults = FALSE)
t017 <- Bonferroni_type_CIs_rxc(n, printresults = FALSE)
t018 <- Brant_test_2xc(n3, printresults = FALSE)
t019 <- BreslowDay_homogeneity_test_stratified_2x2(n4, printresults = FALSE)
t020 <- Chacko_test_1xc(n, printresults = FALSE)
t021 <- ClopperPearson_exact_CI_1x2_beta_version(13, 16, printresults = FALSE)
t022 <- ClopperPearson_exact_CI_1x2(13, 16, printresults = FALSE)
t023 <- ClopperPearson_midP_CI_1x2(13, 16, printresults = FALSE)
t024 <- Cochran_Q_test_stratified_2x2(n4, printresults = FALSE)
t025 <- CochranArmitage_CI_rx2(n, 1:2, printresults = FALSE)
t026 <- CochranArmitage_exact_cond_midP_tests_rx2(n2, 1:4, printresults = FALSE)
t027 <- CochranArmitage_MH_tests_rx2(n2, 1:4, printresults = FALSE)
t028 <- CochranMantelHaenszel_test_stratified_2x2(n4, printresults = FALSE)
t029 <- Cornfield_exact_conditional_CI_2x2(n, printresults = FALSE)
t030 <- Cornfield_midP_CI_2x2(n, printresults = FALSE)
t031 <- Cumulative_models_for_2xc(n3, printresults = FALSE)
t032 <- Cumulative_models_for_rxc(n3, printresults = FALSE)
t033 <- Exact_binomial_test_1x2(13, 16, .5, printresults = FALSE)
t034 <- Exact_cond_midP_linear_rank_tests_2xc(n5, printresults = FALSE)
t035 <- Exact_cond_midP_tests_rxc(n5[, 1:2], printresults = FALSE)
t036 <- Exact_cond_midP_unspecific_ordering_rx2(n6, "decreasing", printresults = FALSE)
t037 <- Exact_multinomial_test_1xc(1:3, seq(.4, .6, .1), printresults = FALSE)
t038 <- Exact_unconditional_test_2x2(n, printresults = FALSE)
t039 <- Fisher_exact_test_2x2(n, printresults = FALSE)
t040 <- Exact_unconditional_test_2x2(n, printresults = FALSE)
t041 <- Fisher_midP_test_2x2(n, printresults = FALSE)
t042 <- FisherFreemanHalton_asymptotic_test_rxc(n, printresults = FALSE)
t043 <- FleissEveritt_test_paired_cxc(n5, printresults = FALSE)
t044 <- FleissLevinPaik_test_paired_cxc(n5, printresults = FALSE)
t045 <- gamma_coefficient_rxc_bca(n, nboot = 160, printresults = FALSE)
t046 <- gamma_coefficient_rxc(n, printresults = FALSE)
t047 <- Gart_adjusted_logit_CI_2x2(n, printresults = FALSE)
t048 <- Gold_Wald_CIs_1xc(n, printresults = FALSE)
t049 <- Goodman_Wald_CIs_1xc(n, printresults = FALSE)
t050 <- Goodman_Wald_CIs_for_diffs_1xc(n, printresults = FALSE)
t051 <- Goodman_Wilson_score_CIs_1xc(n, printresults = FALSE)
t052 <- Independence_smoothed_logit_CI_2x2(n, printresults = FALSE)
t053 <- Inv_sinh_CI_OR_2x2(n, printresults = FALSE)
t054 <- Inv_sinh_CI_ratio_2x2(n, printresults = FALSE)
t055 <- InverseVariance_estimate_stratified_2x2(n4, printresults = FALSE)
t056 <- Jeffreys_CI_1x2(13, 16, printresults = FALSE)
t057 <- JonckheereTerpstra_test_rxc(n, printresults = FALSE)
t058 <- Katz_log_CI_2x2(n, printresults = FALSE)
t059 <- Kendalls_tau_b_rxc_bca(n, nboot = 160, printresults = FALSE)
t060 <- Kendalls_tau_b_rxc(n, printresults = FALSE)
t061 <- Koopman_asymptotic_score_CI_2x2(n, printresults = FALSE)
t062 <- KruskalWallis_asymptotic_test_rxc(n, printresults = FALSE)
t063 <- linear_by_linear_test_rxc(n, printresults = FALSE)
t064 <- LR_CI_1x2(13, 16, printresults = FALSE)
t065 <- LR_test_1x2(13, 16, .3, printresults = FALSE)
t066 <- LR_test_1xc(1:3, c(.3, .5, .1), printresults = FALSE)
t067 <- LR_test_2x2(n, printresults = FALSE)
t068 <- MantelHaenszel_estimate_stratified_2x2(n4, printresults = FALSE)
t069 <- MantelHaenszel_test_2xc(n, printresults = FALSE)
t070 <- McNemar_asymptotic_test_CC_paired_2x2(n, printresults = FALSE)
t071 <- McNemar_asymptotic_test_paired_2x2(n, printresults = FALSE)
t072 <- McNemar_exact_cond_test_paired_2x2(n2, printresults = FALSE)
t073 <- McNemar_exact_unconditional_test_paired_2x2(n, printresults = FALSE)
t074 <- McNemar_midP_test_paired_2x2(n, printresults = FALSE)
t075 <- McNemarBowker_test_paired_cxc(n, printresults = FALSE)
t076 <- Mee_asymptotic_score_CI_2x2(n, printresults = FALSE)
t077 <- MidP_binomial_test_1x2(13, 16, .3, printresults = FALSE)
t078 <- MidP_multinomial_test_1xc(n, runif(4), printresults = FALSE)
t079 <- MiettinenNurminen_asymptotic_score_CI_difference_2x2(n, printresults = FALSE)
t080 <- MiettinenNurminen_asymptotic_score_CI_OR_2x2(n, printresults = FALSE)
t081 <- MiettinenNurminen_asymptotic_score_CI_ratio_2x2(n, printresults = FALSE)
t082 <- ML_estimates_and_CIs_stratified_2x2(n4, printresults = FALSE)
t083 <- MOVER_R_Wilson_CI_OR_2x2(n, printresults = FALSE)
t084 <- MOVER_R_Wilson_CI_ratio_2x2(n, printresults = FALSE)
t085 <- MOVER_Wilson_score_CI_paired_2x2(n, printresults = FALSE)
t086 <- Newcombe_hybrid_score_CI_2x2(n, printresults = FALSE)
t087 <- Newcombe_square_and_add_CI_paired_2x2(n, printresults = FALSE)
t088 <- Pearson_chi_squared_test_1xc(n, runif(4), printresults = FALSE)
t089 <- Pearson_chi_squared_test_2x2(n, printresults = FALSE)
t090 <- Pearson_chi_squared_test_CC_2x2(n, printresults = FALSE)
t091 <- Pearson_correlation_coefficient_rxc_bca(n, nboot = 160, printresults = FALSE)
t092 <- Pearson_correlation_coefficient_rxc(n, printresults = FALSE)
t093 <- Pearson_LR_homogeneity_test_stratified_2x2(n4, printresults = FALSE)
t094 <- Pearson_LR_test_common_effect_stratified_2x2(n4, printresults = FALSE)
t095 <- Pearson_LR_tests_cum_OR_2xc(n, printresults = FALSE)
t096 <- Pearson_LR_tests_rxc(n, printresults = FALSE)
t097 <- Pearson_LR_tests_unspecific_ordering_rx2(n, "increasing", printresults = FALSE)
t098 <- Pearson_residuals_rxc(n, printresults = FALSE)
t099 <- Peto_homogeneity_test_stratified_2x2(n4, printresults = FALSE)
t100 <- Peto_OR_estimate_stratified_2x2(n4, printresults = FALSE)
t101 <- PriceBonett_approximate_Bayes_CI_2x2(n, printresults = FALSE)
t102 <- QuesenberryHurst_Wilson_score_CIs_1xc(n, printresults = FALSE)
t103 <- RBG_test_and_CI_stratified_2x2(n4, printresults = FALSE)
t104 <- Scheffe_type_CIs_paired_cxc(n, printresults = FALSE)
t105 <- Scheffe_type_CIs_rxc(n, printresults = FALSE)
t106 <- Score_test_1x2(13, 16, .5, printresults = FALSE)
t107 <- Score_test_and_CI_marginal_mean_scores_paired_cxc(n, runif(4), printresults = FALSE)
t108 <- Score_test_CC_1x2(13, 16, .5, printresults = FALSE)
t109 <- Score_test_for_effect_in_the_probit_model_2xc(n, rnorm(4), printresults = FALSE)
t110 <- Spearman_correlation_coefficient_rxc_bca(n, nboot = 160, printresults = FALSE)
t111 <- Spearman_correlation_coefficient_rxc(n, printresults = FALSE)
t112 <- invisible(capture.output(stratified_2x2_tables(n4)))
t113 <- Stuart_test_paired_cxc(n2, printresults = FALSE)
t114 <- Tang_asymptotic_score_CI_paired_2x2(n, printresults = FALSE)
t115 <- Tango_asymptotic_score_CI_paired_2x2(n, printresults = FALSE)
t116 <- invisible(capture.output(the_1x2_table_CIs(13, 16)))
t117 <- invisible(capture.output(the_1x2_table_tests(13, 16, .4)))
t118 <- invisible(capture.output(the_1xc_table_CIs(n)))
t119 <- invisible(capture.output(the_1xc_table_tests(n, runif(4))))
t120 <- invisible(capture.output(the_2x2_table_CIs_difference(n)))
t121 <- invisible(capture.output(the_2x2_table_CIs_OR(n)))
t122 <- invisible(capture.output(the_2x2_table_CIs_ratio(n)))
t123 <- invisible(capture.output(the_2x2_table_tests(n)))
t124 <- invisible(capture.output(the_2xc_table(n7, direction = "decreasing")))
t125 <- invisible(capture.output(the_paired_2x2_table_CIs_difference(n)))
t126 <- invisible(capture.output(the_paired_2x2_table_CIs_OR(n)))
t127 <- invisible(capture.output(the_paired_2x2_table_CIs_ratio(n)))
t128 <- invisible(capture.output(the_paired_2x2_table_tests(n)))
t129 <- invisible(capture.output(the_paired_cxc_table_nominal(n)))
t130 <- invisible(capture.output(the_paired_cxc_table_ordinal(n, rnorm(4))))
t131 <- invisible(capture.output(the_rx2_table(n2, skip_exact = TRUE)))
t132 <- invisible(capture.output(the_rxc_table(n2, nboot = 0)))
t133 <- Transformed_Blaker_exact_CI_paired_2x2(n, printresults = FALSE)
t134 <- Transformed_Clopper_Pearson_exact_CI_paired_2x2(n, printresults = FALSE)
t135 <- Transformed_Clopper_Pearson_midP_CI_paired_2x2(n, printresults = FALSE)
t136 <- Transformed_Wilson_score_CI_paired_2x2(n, printresults = FALSE)
t137 <- Trend_estimate_CI_tests_rx2(n, 1:2, printresults = FALSE)
t138 <- Uncorrected_asymptotic_score_CI_2x2(n, printresults = FALSE)
t139 <- Wald_CI_1x2(13, 16, printresults = FALSE)
t140 <- Wald_CI_2x2(n, printresults = FALSE)
t141 <- Wald_CI_AgrestiMin_paired_2x2(n, printresults = FALSE)
t142 <- Wald_CI_BonettPrice_paired_2x2(n, printresults = FALSE)
t143 <- Wald_CI_CC_1x2(13, 16, printresults = FALSE)
t144 <- Wald_CI_CC_2x2(n, printresults = FALSE)
t145 <- Wald_CI_diff_CC_paired_2x2(n, printresults = FALSE)
t146 <- Wald_CI_diff_paired_2x2(n, printresults = FALSE)
t147 <- Wald_CI_OR_Laplace_paired_2x2(n, printresults = FALSE)
t148 <- Wald_CI_OR_paired_2x2(n, printresults = FALSE)
t149 <- Wald_CI_ratio_paired_2x2(n, printresults = FALSE)
t150 <- Wald_test_1x2(13, 16, .1, printresults = FALSE)
t151 <- Wald_test_and_CI_common_diff_stratified_2x2(n4, printresults = FALSE)
t152 <- Wald_test_and_CI_common_ratio_stratified_2x2(n4, printresults = FALSE)
t153 <- Wald_test_and_CI_marginal_mean_ranks_paired_cxc(n, printresults = FALSE)
t154 <- Wald_test_and_CI_marginal_mean_scores_paired_cxc(n, rnorm(4), printresults = FALSE)
t155 <- Wald_test_CC_1x2(13, 16, .1, printresults = FALSE)
t156 <- Wilson_score_CI_1x2(13, 16, printresults = FALSE)
t157 <- Wilson_score_CI_CC_1x2(13, 16, printresults = FALSE)
t158 <- Woolf_logit_CI_2x2(n, printresults = FALSE)
t159 <- Woolf_test_and_CI_stratified_2x2(n4, printresults = FALSE)
t160 <- Z_unpooled_test_2x2(n, printresults = FALSE)

test_that("Output classes are the expected", {
  expect_is(t001, "data.frame")
  expect_is(t002, "data.frame")
  expect_is(t003, "data.frame")
  expect_is(t004, "data.frame")
  expect_is(t005, "numeric")
  expect_is(t006, "data.frame")
  expect_is(t007, "data.frame")
  expect_is(t008, "list")
  expect_is(t009, "numeric")
  expect_is(t010, "numeric")
  expect_is(t011, "numeric")
  expect_is(t012, "numeric")
  expect_is(t013, "numeric")
  expect_is(t014, "list")
  expect_is(t015, "list")
  expect_is(t016, "list")
  expect_is(t017, "list")
  expect_is(t018, "data.frame")
  expect_is(t019, "list")
  expect_is(t020, "data.frame")
  expect_is(t021, "list")
  expect_is(t022, "numeric")
  expect_is(t023, "numeric")
  expect_is(t024, "list")
  expect_is(t025, "data.frame")
  expect_is(t026, "data.frame")
  expect_is(t027, "list")
  expect_is(t028, "list")
  expect_is(t029, "data.frame")
  expect_is(t030, "data.frame")
  expect_is(t031, "list")
  expect_is(t032, "list")
  expect_is(t033, "numeric")
  expect_is(t034, "data.frame")
  expect_is(t035, "list")
  expect_is(t036, "data.frame")
  expect_is(t037, "numeric")
  expect_is(t038, "numeric")
  expect_is(t039, "numeric")
  expect_is(t040, "numeric")
  expect_is(t041, "numeric")
  expect_is(t042, "list")
  expect_is(t043, "list")
  expect_is(t044, "list")
  expect_is(t045, "list")
  expect_is(t046, "list")
  expect_is(t047, "data.frame")
  expect_is(t048, "data.frame")
  expect_is(t049, "data.frame")
  expect_is(t050, "data.frame")
  expect_is(t051, "data.frame")
  expect_is(t052, "data.frame")
  expect_is(t053, "data.frame")
  expect_is(t054, "data.frame")
  expect_is(t055, "list")
  expect_is(t056, "numeric")
  expect_is(t057, "list")
  expect_is(t058, "data.frame")
  expect_is(t059, "list")
  expect_is(t060, "list")
  expect_is(t061, "data.frame")
  expect_is(t062, "list")
  expect_is(t063, "list")
  expect_is(t064, "numeric")
  expect_is(t065, "numeric")
  expect_is(t066, "data.frame")
  expect_is(t067, "data.frame")
  expect_is(t068, "list")
  expect_is(t069, "data.frame")
  expect_is(t070, "list")
  expect_is(t071, "list")
  expect_is(t072, "numeric")
  expect_is(t073, "numeric")
  expect_is(t074, "numeric")
  expect_is(t075, "list")
  expect_is(t076, "data.frame")
  expect_is(t077, "numeric")
  expect_is(t078, "numeric")
  expect_is(t079, "data.frame")
  expect_is(t080, "data.frame")
  expect_is(t081, "data.frame")
  expect_is(t082, "list")
  expect_is(t083, "data.frame")
  expect_is(t084, "data.frame")
  expect_is(t085, "list")
  expect_is(t086, "data.frame")
  expect_is(t087, "list")
  expect_is(t088, "data.frame")
  expect_is(t089, "data.frame")
  expect_is(t090, "data.frame")
  expect_is(t091, "list")
  expect_is(t092, "list")
  expect_is(t093, "list")
  expect_is(t094, "list")
  expect_is(t095, "list")
  expect_is(t096, "list")
  expect_is(t097, "list")
  expect_is(t098, "list")
  expect_is(t099, "list")
  expect_is(t100, "list")
  expect_is(t101, "data.frame")
  expect_is(t102, "data.frame")
  expect_is(t103, "list")
  expect_is(t104, "list")
  expect_is(t105, "list")
  expect_is(t106, "numeric")
  expect_is(t107, "list")
  expect_is(t108, "numeric")
  expect_is(t109, "data.frame")
  expect_is(t110, "list")
  expect_is(t111, "list")
  expect_is(t112, "character")
  expect_is(t113, "list")
  expect_is(t114, "list")
  expect_is(t115, "list")
  expect_is(t116, "character")
  expect_is(t117, "character")
  expect_is(t118, "character")
  expect_is(t119, "character")
  expect_is(t120, "character")
  expect_is(t121, "character")
  expect_is(t122, "character")
  expect_is(t123, "character")
  expect_is(t124, "character")
  expect_is(t125, "character")
  expect_is(t126, "character")
  expect_is(t127, "character")
  expect_is(t128, "character")
  expect_is(t129, "character")
  expect_is(t130, "character")
  expect_is(t131, "character")
  expect_is(t132, "character")
  expect_is(t133, "list")
  expect_is(t134, "list")
  expect_is(t135, "list")
  expect_is(t136, "list")
  expect_is(t137, "list")
  expect_is(t138, "data.frame")
  expect_is(t139, "numeric")
  expect_is(t140, "data.frame")
  expect_is(t141, "list")
  expect_is(t142, "list")
  expect_is(t143, "numeric")
  expect_is(t144, "data.frame")
  expect_is(t145, "list")
  expect_is(t146, "list")
  expect_is(t147, "list")
  expect_is(t148, "list")
  expect_is(t149, "list")
  expect_is(t150, "numeric")
  expect_is(t151, "list")
  expect_is(t152, "list")
  expect_is(t153, "list")
  expect_is(t154, "list")
  expect_is(t155, "numeric")
  expect_is(t156, "numeric")
  expect_is(t157, "numeric")
  expect_is(t158, "data.frame")
  expect_is(t159, "list")
  expect_is(t160, "data.frame")
})

test_that("Output names are the expected", {
  lue <- c("lower", "upper", "estimate")
  ptdf <- c("P", "T", "df")
  LUe <- c("L", "U", "estimate")
  LUdelta <- c("L", "U", "deltahat")
  LUdiff <- c("L", "U", "differences")
  luee <- c("lower", "upper", "estimate.1", "estimate.2")
  pz <- c("P", "Z")
  psdf <- c("p.value", "statistic", "df")
  rplu <- c("rP", "L", "U")
  plr_df <- c("P_LR", "T_LR", "df_LR", "P_Pearson", "T_Pearson", "df_Pearson")
  plr <- c("T_Pearson", "P_Pearson", "T_LR", "P_LR")
  ps <- c("p.value", "statistic")
  expect_named(t001, lue)
  expect_named(t002, lue)
  expect_named(t003, lue)
  expect_named(t004, lue)
  expect_named(t005, lue)
  expect_named(t006, lue)
  expect_named(t007, lue)
  expect_named(t008, ptdf)
  expect_named(t009, lue)
  expect_named(t010, NULL)
  expect_named(t011, lue)
  expect_named(t012, lue)
  expect_named(t013, NULL)
  expect_named(t014, LUe)
  expect_named(t015, LUe)
  expect_named(t016, LUdelta)
  expect_named(t017, LUdiff)
  expect_named(t018, ptdf)
  expect_named(t019, ptdf)
  expect_named(t020, ptdf)
  expect_named(t021, LUe)
  expect_named(t022, lue)
  expect_named(t023, lue)
  expect_named(t024, c("P", "Q", "df"))
  expect_named(t025, lue)
  expect_named(t026, c("P", "midP"))
  expect_named(t027, c("Z_CA", "P_CA", "Z_CA_mod", "P_CA_mod", "Z_MH", "P_MH"))
  expect_named(t028, ptdf)
  expect_named(t029, lue)
  expect_named(t030, lue)
  expect_named(t031,
    c(
      "betahat", "OR", "se", "D", "P_D", "df_D", "X2", "P_X2", "df_X2",
      "Z_Wald", "T_Wald", "P_Wald", "T_LR", "P_LR", "df_LR", "Z_MW", "P_MW",
      "Wald_CI", "Wald_CI_OR", "Wald_CI_width"
    )
  )
  expect_named(
    t032,
    c(
      "betahat", "OR", "se", "D", "df_D", "P_D", "X2", "df_X2", "P_X2",
      "Z_Wald", "T_Wald", "P_Wald", "T_LR", "df_LR", "P_LR", "Wald_CI",
      "Wald_CI_OR", "Wald_CI_width"
    )
  )
  expect_named(t033, NULL)
  expect_named(t034, c("P", "midP"))
  expect_named(t035, c("P_FFH", "midP_FFH", "P_Pearson", "midP_Pearson", "P_LR", "midP_LR", "P_KW", "midP_KW", "P_lbl", "midP_lbl", "P_JT", "midP_JT"))
  expect_named(t036, c("P", "midP"))
  expect_named(t037, NULL)
  expect_named(t038, NULL)
  expect_named(t039, NULL)
  expect_named(t040, NULL)
  expect_named(t041, NULL)
  expect_named(t042, ptdf)
  expect_named(t043, ptdf)
  expect_named(t044, ptdf)
  expect_named(t045, c("gamma", "L", "U"))
  expect_named(t046, c("gamma", "C", "D"))
  expect_named(t047, lue)
  expect_named(t048, luee)
  expect_named(t049, luee)
  expect_named(t050, lue)
  expect_named(t051, luee)
  expect_named(t052, lue)
  expect_named(t053, lue)
  expect_named(t054, lue)
  expect_named(t055, c("estimate", "psihat", "v"))
  expect_named(t056, lue)
  expect_named(t057, pz)
  expect_named(t058, lue)
  expect_named(t059, c("tau_b", "L", "U"))
  expect_named(t060, c("tau_b", "L", "U"))
  expect_named(t061, lue)
  expect_named(t062, ptdf)
  expect_named(t063, pz)
  expect_named(t064, lue)
  expect_named(t065, psdf)
  expect_named(t066, ptdf)
  expect_named(t067, psdf)
  expect_named(t068, c("estimate", "psihat", "w"))
  expect_named(t069, ptdf)
  expect_named(t070, pz)
  expect_named(t071, pz)
  expect_named(t072, NULL)
  expect_named(t073, NULL)
  expect_named(t074, NULL)
  expect_named(t075, ptdf)
  expect_named(t076, lue)
  expect_named(t077, NULL)
  expect_named(t078, NULL)
  expect_named(t079, lue)
  expect_named(t080, lue)
  expect_named(t081, lue)
  expect_named(t082, c("alphahat", "alphahatSE", "alphahatCI", "betahat", "betahatSE", "betahatCI", "gammahat", "gammahatSE", "gammahatCI", "pihat"))
  expect_named(t083, lue)
  expect_named(t084, lue)
  expect_named(t085, LUe)
  expect_named(t086, lue)
  expect_named(t087, LUe)
  expect_named(t088, ptdf)
  expect_named(t089, psdf)
  expect_named(t090, psdf)
  expect_named(t091, rplu)
  expect_named(t092, rplu)
  expect_named(t093, plr_df)
  expect_named(t094, plr_df)
  expect_named(t095, plr)
  expect_named(t096, c("T_Pearson", "df_Pearson", "P_Pearson", "T_LR", "df_LR", "P_LR"))
  expect_named(t097, plr)
  expect_named(t098, c("residuals", "std_residuals"))
  expect_named(t099, ptdf)
  expect_named(t100, c("estimate", "expectation", "variance"))
  expect_named(t101, lue)
  expect_named(t102, luee)
  expect_named(t103, c("P", "Z", "L", "U", "thetahatMH", "SElog"))
  expect_named(t104, LUdelta)
  expect_named(t105, LUdiff)
  expect_named(t106, ps)
  expect_named(t107, c("P", "Z_score", "L", "U", "estimate"))
  expect_named(t108, ps)
  expect_named(t109, ptdf)
  expect_named(t110, c("rho", "L", "U"))
  expect_named(t111, c("rho", "L", "U", "L_BW", "U_BW"))
  expect_named(t112, NULL)
  expect_named(t113, c("P", "T0", "df"))
  expect_named(t114, LUe)
  expect_named(t115, LUe)
  expect_named(t116, NULL)
  expect_named(t117, NULL)
  expect_named(t118, NULL)
  expect_named(t119, NULL)
  expect_named(t120, NULL)
  expect_named(t121, NULL)
  expect_named(t122, NULL)
  expect_named(t123, NULL)
  expect_named(t124, NULL)
  expect_named(t125, NULL)
  expect_named(t126, NULL)
  expect_named(t127, NULL)
  expect_named(t128, NULL)
  expect_named(t129, NULL)
  expect_named(t130, NULL)
  expect_named(t131, NULL)
  expect_named(t132, NULL)
  expect_named(t133, LUe)
  expect_named(t134, LUe)
  expect_named(t135, LUe)
  expect_named(t136, LUe)
  expect_named(t137, c("betahat", "Z_Wald", "P_Wald", "T_LR", "P_LR", "df_LR", "chi2", "P_chi2", "df_chi2", "D", "P_D", "df_D", "CI_Wald", "CI_Wald_width"))
  expect_named(t138, lue)
  expect_named(t139, lue)
  expect_named(t140, lue)
  expect_named(t141, LUe)
  expect_named(t142, LUe)
  expect_named(t143, lue)
  expect_named(t144, lue)
  expect_named(t145, LUe)
  expect_named(t146, LUe)
  expect_named(t147, LUe)
  expect_named(t148, LUe)
  expect_named(t149, LUe)
  expect_named(t150, ps)
  expect_named(t151, c("P", "Z", "L", "U", "deltahat"))
  expect_named(t152, c("P", "Z", "L", "U", "phihat"))
  expect_named(t153, c("tauhat", "SE_tau", "CI_tau", "Z_Wald", "P", "alphahat", "SE_alpha", "CI_alpha", "CI_alpha_logit", "Z_Wald_logit", "P_logit", "CI_tau_logit"))
  expect_named(t154, c("P", "Z_Wald", LUe))
  expect_named(t155, ps)
  expect_named(t156, lue)
  expect_named(t157, lue)
  expect_named(t158, lue)
  expect_named(t159, c("P", "Z", "L", "U", "thetahatIV"))
  expect_named(t160, ps)
})
