% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delete_at.R
\name{delete_at}
\alias{delete_at}
\alias{ref_delete_at}
\alias{delete_at.Container}
\alias{ref_delete_at.Container}
\alias{delete_at.dict.table}
\alias{ref_delete_at.dict.table}
\title{Delete Elements at Indices Safely}
\usage{
delete_at(.x, ...)

ref_delete_at(.x, ...)

\method{delete_at}{Container}(.x, ...)

\method{ref_delete_at}{Container}(.x, ...)

\method{delete_at}{dict.table}(.x, ...)

\method{ref_delete_at}{dict.table}(.x, ...)
}
\arguments{
\item{.x}{any \code{R} object.}

\item{...}{indices at which values are to be deleted.}
}
\value{
For \code{Container}, an object of class \code{Container} (or one of the
respective derived classes).

For \code{dict.table}, an object of class \code{dict.table}.
}
\description{
Search and remove values at given indices, which can be numeric or character
or both. If any given index is invalid, an error is signaled. Indices can be
numbers or names or both.
}
\examples{

co = container(a = 1, b = 2, 3)
delete_at(co, "a", "b")          # [3]
delete_at(co, 1:2)               # [3]
delete_at(co, "a", 3)            # [b = 2]
\dontrun{
delete_at(co, 4)                 # index out of range
delete_at(co, "x")               # names(s) not found: 'x'
}

dit = as.dict.table(head(sleep))
dit
delete_at(dit, "ID")
delete_at(dit, "ID", 1)
\dontrun{
delete_at(dit, "foo")   # Column 'foo' not in dict.table
}
}
