% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3-integer64.R
\name{opts_integer64}
\alias{opts_integer64}
\title{Constructive options for class 'integer64'}
\usage{
opts_integer64(constructor = c("as.integer64", "next", "double"), ...)
}
\arguments{
\item{constructor}{String. Name of the function used to construct the object, see Details section.}

\item{...}{Additional options used by user defined constructors through the \code{opts} object}
}
\value{
An object of class <constructive_options/constructive_options_integer64>
}
\description{
These options will be used on objects of class 'integer64'.
}
\details{
Depending on \code{constructor}, we construct the object as follows:
\itemize{
\item \code{"as.integer64"} (default): Build the object using \code{as.integer64()} on a
character vector.
\item \code{"next"} : Use the constructor for the next supported class. Call \code{.class2()}
on the object to see in which order the methods will be tried.
\item \code{"double"} : We define as an atomic vector and repair attributes.
}

We don't recommend the "next" and "double" constructors for this class as
they give incorrect results on negative or \code{NA} "integer64" objects
due to some quirks in the implementation of the 'bit64' package.
}
