% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ms_authorization.R
\name{ms_get_token}
\alias{ms_get_token}
\alias{ms_token_expired}
\title{Get Microsoft Text To Speech (TTS) or Cognitive Services Token from API Key}
\usage{
ms_get_token(api_key = NULL, region = "westus")

ms_token_expired(token = NULL)
}
\arguments{
\item{api_key}{Microsoft Azure Cognitive Services API key}

\item{region}{Subscription region for API key. For more info, see
\url{https://learn.microsoft.com/en-us/azure/cognitive-services/speech-service/regions}}

\item{token}{An authentication of class \code{token},
likely from \code{\link{ms_get_token}}}
}
\value{
A list of the request and token

Logical vector, indicating whether token has expired
}
\description{
Get Microsoft Text To Speech (TTS) or Cognitive Services Token from API Key

Check if token has expired
}
\examples{
\dontshow{if (ms_valid_key()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Get token where region is westus
token = ms_get_token(region = "westus")
\dontshow{\}) # examplesIf}
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Check if token XXX has expired
ms_token_expired(token = "XXX")
\dontshow{\}) # examplesIf}
}
