% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateHelpers.R
\name{genResponses}
\alias{genResponses}
\title{genResponses}
\usage{
genResponses(
  abilities,
  groups = NULL,
  itemParams,
  BMatrix = 1,
  mcarP = 0,
  perturbR = NULL
)
}
\arguments{
\item{abilities}{A person by latent-dimension matrix of abilities.
One column per dimension.}

\item{groups}{A vector of factors of the same length as \code{abilities} that
allocates each case to a group. Used in perturbR. Defaults to NULL such that
all cases are in the one group.}

\item{itemParams}{A list of item parameters of the structure used in \code{simplef}
(a matrix of k categories by four (category score, delta dot, tau, discrimination)).
See conquestr::makeItemList for a helper to generate this list.}

\item{BMatrix}{A simplified B-matrix mapping dimensions (columns) to items (rows).
Or the integer "1" if items are dichotomous and ability is uni-dimensional.}

\item{mcarP}{A double indicating the proportion of missing data
under the MCAR assumption.}

\item{perturbR}{A list of lists, where each element of the list refers to one item
and contains a list of elements describing how responses to that item should
be perturbed to model misfit.
Each element of the list should contain, in order:
\itemize{
\item item number (int). Which item in \code{itemParams} is affected,
\item type of perturbation (string) to apply. One of
\itemize{
\item "discrimination" - increases or decreases the discrimination of the item
at a location specified by the user.
\item "shift" - increases or decreases the location of the item as to create a
uniform shift in the CCC.
\item ...more to come,
}
\item scoring perturbation factor (double). When the type is "discrimination", this defines
the scale that the discrimination is increased or decreased. For example, if
the item has discrimination of 1, and the perturbation factor is 1.2, the
resulting probabilities will be calculated assuming the discrimination
is 1 * 1.2 = 1.2. Note that is the value given here is 1, than this kind of
perturbation is the same as "shift".
When the type is "shift" this value is always ignored.
\item pivot point (double), When the type is "discrimination", this defines the
location  around which the perturbation is applied relative to
the delta dot. That is, when the type is "discrimination" and the
"perturbation factor" is > 1, probabilities above the pivot point
will be overestimated (generated responses will higher than expectation)
and probabilities below the pivot point will be underestimated
(generated responses will lower than expectation). When the pivot point
is 0, this calculation happens at the item location parameter (e.g., at the
category boundary).
When the type is "shift", this is the value added to the item location (delta dot)
as to create a uniform shift (DIF) for the group.
\item group (string). The group found in \verb{groups that should be perturbed. note that if }groups\verb{is not used in call to}genResponses` than this
value is ignored and all cases' responses are perturbed.
}}
}
\value{
A matrix, \code{n} cases by \code{i} items, of scored item responses.
}
\description{
Generates response vectors for \code{n} cases to \code{i} items given
known item parameters, person abilities, and (optionally) other inputs.
}
\examples{
  myItem <- matrix(c(0, 0, 0, 0, 1, 1, 0, 1), ncol = 4, byrow = TRUE)
  myItems <- list(myItem, myItem)
  myItems[[2]][2, 2] <- -1 # make the second item delta equal to -1
  myResponses <- genResponses(abilities = rnorm(100), itemParams = myItems)
}
\seealso{
\code{\link[=simplef]{simplef()}}, \code{browseVignettes("conquestr")}
}
