% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/integrations.R
\name{get_integrations}
\alias{get_integrations}
\title{List all OAuth integrations on the Connect server}
\usage{
get_integrations(client)
}
\arguments{
\item{client}{A \code{Connect} R6 client object.}
}
\value{
A list of OAuth integrations. Each integration is a list with the
following elements (all character strings unless indicated otherwise):
\itemize{
\item \code{id}: The internal identifier of this OAuth integration.
\item \code{guid}: The GUID of this OAuth integration.
\item \code{created_time}: The timestamp (RFC3339) indicating when this integration
was created.
\item \code{updated_time}: The timestamp (RFC3339) indicating when this integration
was last updated
\item \code{name}: A descriptive name to identify the OAuth integration.
\item \code{description}: A brief text to describe the OAuth integration.
\item \code{template}: The template used to configure this OAuth integration.
\item \code{auth_type}: The authentication type indicates which OAuth flow is used by
this integration.
\item \code{config}: A sub-list list with the OAuth integration configuration. Fields
differ between integrations.
}

Use \code{\link[=as.data.frame]{as.data.frame()}} or \code{\link[tibble:as_tibble]{tibble::as_tibble()}} to convert to a data frame with
parsed types. In the resulting data frame:
\itemize{
\item \code{created_time} and \code{updated_time} are parsed to \code{POSIXct}.
\item \code{config} remains as a list-column.
}
}
\description{
Retrieve information about all OAuth integrations available to Posit Connect.
You must have administrator or publisher privileges to perform this action.
}
\examples{
\dontrun{
client <- connect()

# Fetch all OAuth integrations
integrations <- get_integrations(client)


# Update the configuration and metadata for a subset of integrations.
json_payload <- toJSON(list(
  description = "New Description",
  config = list(
    client_secret = "new-client-secret"
  )
), auto_unbox = TRUE)

results <- integrations |>
  purrr::keep(\(x) x$template == "service_to_update") |>
  purrr::map(\(x) client$PATCH(paste0("v1/oauth/integrations/", x$guid), body = json_payload))


# Convert to tibble or data frame
integrations_df <- tibble::as_tibble(integrations)
}

}
\seealso{
\code{\link[=get_oauth_credentials]{get_oauth_credentials()}}, \code{\link[=get_oauth_content_credentials]{get_oauth_content_credentials()}}
}
