% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RFunctions_1_0_2.r
\name{widen}
\alias{widen}
\title{Function to create transform data from person-time format to person format suitable for lengthen()}
\usage{
widen(input, id, time, exposure, covariate, history = NULL,
  weight.exposure = NULL, weight.censor = NULL, strata = NULL,
  censor = NULL)
}
\arguments{
\item{input}{dataframe in long format e.g., a person-time format}

\item{id}{unique identifier at the unit (person) level}

\item{time}{unique index for each observation within each unit}

\item{exposure}{the exposure of interest at time t}

\item{covariate}{a vector of covariates at time t}

\item{history}{variable describing exposure history through time t}

\item{weight.exposure}{inverse probability weight for exposure, at or through time t}

\item{weight.censor}{cumulative inverse probability weight for censoring through time t}

\item{strata}{propensity score strata at time t}

\item{censor}{censoring indicators at time t}
}
\value{
A "wide" dataframe where each row uniquely indexes
a single subject’s data, so that columns index measurement of
each variable at each time. The indices should be indicated
with an underscore suffix followed by the time, e.g.
\code{variable_1,variable_2}.
}
\description{
Function to create transform data from person-time format to person format suitable for lengthen()
}
\details{
Numeric formats are preserved, factors are coerced into character.
}
\examples{
# Simulate long data set for two subjects
id <- as.numeric(c(1, 1, 1, 2, 2, 2))
time <- as.numeric(c(0, 1, 2, 0, 1, 2))
a <- as.numeric(c(0, 1, 1, 1, 1, 0))
l <- as.numeric(rbinom(6, 1, 0.5))
m <- as.numeric(rbinom(6, 1, 0.5))
n <- as.numeric(rbinom(6, 1, 0.5))

mydata.long <- data.frame(id, time, a, l, m, n)

# Run the widen() function
mydata.wide <- widen(input=mydata.long,
                     id="id", time="time",
                     exposure="a",
                     covariate=c("l","m","n")
                     )
}
