#' Parse the configuration {{var}} format, and replace it by extra.list values
#'
#' @param config A list that were generated by read.config/eval.config/eval.config.merge
#' @param extra.list A list that can replace the configuration file "{{debug}}" by list(debug = TRUE), and {{debug}} will be setted to TRUE
#' @param other.config Path of another configuration file that can replace the configuration file "{{key:value}}" 
#' @return A list
#' @export
#' @examples
#' config.json <- system.file('extdata', 'config.json', package='configr')
#' config <- read.config(config.json)
#' parse.extra(config, list(debug = "TRUE"))
parse.extra <- function(config, extra.list = list(), other.config = "") {
  if(!is.null(names(extra.list))) {
    config <- parse.extra.list(config, extra.list)
  }
  if(other.config != "") {
    config <- parse.extra.config(config, other.config)
  }
  return(config)
}

# Parse the configuration {{var}} format string, and replace it by extra.list values
parse.extra.list <- function(config, extra.list) {
  list.names <- names(config)
  args.all <- extra.list
  for(list.item in list.names) {
    list.tmp <- config[[list.item]]
    if(is.list(list.tmp)) {
      config[[list.item]] <- parse.extra(config[[list.item]], args.all)
    } else {
      if(all(!str_detect(list.tmp, "\\{\\{"))) {
        next
      }
      text <- str_extract_all(list.tmp, "\\{\\{.*\\}\\}")
      text <- str_replace_all(text, fixed("{{"), "")
      text <- str_split(text, fixed("}}"))
      text <- text[[1]]
      text <- text[text != ""]
      text <- str_replace_all(text, " ", "")
      for(item in text) {
        if(str_detect(item, ":")){
          next
        }
        if(!item %in% names(args.all)) {
          next
        }
        item.value <- eval(parse(text = sprintf("args.all$%s", item)))
        config[[list.item]] <- str_replace_all(config[[list.item]], sprintf("\\{\\{%s\\}\\}", item), item.value)
      }
    }
  }
  return(config)
}

# Parse the configuration {{key:value}} format string and replace it by other.config values
parse.extra.config <- function(config, other.config) {
  list.names <- names(config)
  for(list.item in list.names) {
    list.tmp <- config[[list.item]]
    if(is.list(list.tmp)) {
      config[[list.item]] <- parse.extra.config(config[[list.item]], other.config)
    } else {
      if(all(!str_detect(list.tmp, "\\{\\{"))) {
        next
      }
      text <- str_extract_all(list.tmp, "\\{\\{.*\\}\\}")
      text <- str_replace_all(text, fixed("{{"), "")
      text <- str_split(text, fixed("}}"))
      text <- text[[1]]
      text <- text[text != ""]
      text <- str_replace_all(text, " ", "")
      text.list <- str_split(text, ":")
      if(!is.character(other.config)) {
        next
      }
      other.config <- read.config(file = other.config)
      for(i in 1:length(text.list)) {
          pass <- FALSE
          text.list.value <- text.list[[i]]
          for(j in 1:length(text.list.value)) {
              if(j == 1) {
                  if(text.list.value[[j]] %in% names(other.config)){
                    other.config.tmp <- other.config[[text.list.value[[j]]]]
                  } else {
                    other.config.tmp <- list()
                    pass <- TRUE 
                  }
              } else {
                  if(text.list.value[[j]] %in% names(other.config.tmp)){
                    other.config.tmp <- other.config.tmp[[text.list.value[[j]]]]
                  } else {
                    pass <- TRUE 
                  }
              }
          }
          if(!pass) {
            other.config.tmp <- as.character(other.config.tmp)
            config[[list.item]] <- str_replace_all(config[[list.item]], sprintf("\\{\\{%s\\}\\}", text[i]), other.config.tmp)
          }
      }
    }
  }
  return(config)
}
