% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/csSensitivity.R
\name{csSensitivity}
\alias{csSensitivity}
\title{Sensitivity analysis for the Bayes Factors of \code{csCompare} results}
\usage{
csSensitivity(cs1, cs2, group = NULL, data = NULL,
  alternative = "two.sided", conf.level = 0.95, mu = 0,
  rscaleSens = c(0.707, 1, 1.41), out.thres = 3)
}
\arguments{
\item{cs1}{a numeric vector of values. If the \code{data} argument is
defined, it can refer to either the column index or the column name of
the data object. See \code{Details} for more information.}

\item{cs2}{a numeric vector of values. If the \code{data} argument is
defined, it can refer to either the column index or the column name of
the data object. See \code{Details} for more information.}

\item{group}{column index or name that contain the group data. See
\code{Details} for more information.}

\item{data}{numeric matrix or data frame that contains the relevant data.}

\item{alternative}{a character string for the speficication of
the alternative hypothesis. Possible values: \code{"two.sided"} (default),
\code{"greater"} or \code{"less"}.}

\item{conf.level}{Interval's confidence level.}

\item{mu}{a numeric value for the mean value or mean difference.}

\item{rscaleSens}{the scale factor for the prior used in the Bayesian t.test}

\item{out.thres}{The threeshold for detecting outliers (default is 3). If set
to 0, no outliers analysis will be performed. See \code{Details} below for
more information.}
}
\value{
The function returns a data frame with the results of the student
t-test and the Bayesian t-test.
}
\description{
Perform a sensitivity analysis for the Bayes factors computed
with the \code{csCompare} results
}
\details{
\code{csCompare} performs both a student t-test (using the
\code{stats::t.test} function) and a Bayesian t-test (using the
\code{BayesFactor::ttest.tstat}). In case \code{group} is not defined,
paired-samples t-tests are run. In case the \code{group} is
defined, then the csCompare first computes difference scores between the cs1
and the cs2
(i.e., cs1 - cs2).
In case the group argument is defined
but, after removal of NA's (\code{stats::na.omit}), only one group
is defined, a paired samples t-test is run.
}
\examples{
csSensitivity(cs1 = rnorm(n = 100, mean = 10),
cs2 = rnorm(n = 100, mean = 9))
}
\references{
Krypotos, A.-M., Klugkist, I., & Engelhard, I. M. (submitted).Bayesian
Hypothesis Testing for Human Threat Conditioning Research: An introduction
and the condir R package.
}
\seealso{
\code{\link[condir]{csCompare}}, \code{\link[stats]{t.test}},
\code{\link[BayesFactor]{ttest.tstat}}
}

