% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contrast.R
\name{lofcurve}
\alias{lofcurve}
\title{Produce lack-of-fit curve for a contrast tree}
\usage{
lofcurve(
  tree,
  x,
  y,
  z,
  w = rep(1, length(y)),
  doplot = "first",
  col = "black",
  ylim = NULL
)
}
\arguments{
\item{tree}{model object output from contrast() or prune()}

\item{x}{training input predictor data matrix or data frame in same format as in contrast()}

\item{y}{vector, or matrix containing training data input outcome values or censoring intervals for each observation in same format as in contrast()}

\item{z}{vector containing values of a second contrasting quantity for each observation in same observation format as in contrast ()}

\item{w}{observation weights}

\item{doplot}{logical flag. doplot="first" implies start new display. doplot="next" implies super impose plot on existing display. doplot="none" implies no plot displayed.}

\item{col}{color of plotted curve}

\item{ylim}{y-axis limit}
}
\value{
a named list of plotted \code{x} and \code{y} points
}
\description{
Produce lack-of-fit curve for a contrast tree
}
