% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contrast_nns.R
\name{contrast_nns}
\alias{contrast_nns}
\title{Contrast nearest neighbors}
\usage{
contrast_nns(
  x,
  groups = NULL,
  pre_trained = NULL,
  transform = TRUE,
  transform_matrix = NULL,
  bootstrap = TRUE,
  num_bootstraps = 20,
  permute = TRUE,
  num_permutations = 100,
  candidates = NULL,
  N = 20,
  verbose = TRUE
)
}
\arguments{
\item{x}{(quanteda) \code{tokens-class} object}

\item{groups}{(numeric, factor, character) a binary variable of the same length as \code{x}}

\item{pre_trained}{(numeric) a F x D matrix corresponding to pretrained embeddings.
F = number of features and D = embedding dimensions.
rownames(pre_trained) = set of features for which there is a pre-trained embedding.}

\item{transform}{(logical) if TRUE (default) apply the 'a la carte' transformation,
if FALSE ouput untransformed averaged embeddings.}

\item{transform_matrix}{(numeric) a D x D 'a la carte' transformation matrix.
D = dimensions of pretrained embeddings.}

\item{bootstrap}{(logical) if TRUE, use bootstrapping -- sample from texts with replacement and
re-estimate cosine ratios for each sample. Required to get std. errors.}

\item{num_bootstraps}{(numeric) - number of bootstraps to use}

\item{permute}{(logical) - if TRUE, compute empirical p-values using a permutation test}

\item{num_permutations}{(numeric) - number of permutations to use}

\item{candidates}{(character) vector of candidate features for nearest neighbors}

\item{N}{(numeric) - nearest neighbors are subset to the union of the N neighbors of each group (if NULL, ratio is computed for all features)}

\item{verbose}{(logical) - if TRUE, report the documents that had
no overlapping features with the pretrained embeddings provided.}
}
\value{
a data.frame with following columns:
\describe{
\item{\code{feature}}{(character) vector of feature terms corresponding to the nearest neighbors.}
\item{\code{value}}{(numeric) ratio of cosine similarities. Average over bootstrapped samples if bootstrap = TRUE.}
\item{\code{std.error}}{(numeric) std. error of the ratio of cosine similarties. Column is dropped if bootsrap = FALSE.}
\item{\code{p.value}}{(numeric) empirical p-value. Column is dropped if permute = FALSE.}
}
}
\description{
Computes the ratio of cosine similarities between group embeddings and features
--that is, for any given feature it first computes the similarity between that feature
and each group embedding, and then takes the ratio of these two similarities.
This ratio captures how "discriminant" a feature is of a given group.
}
\examples{

library(quanteda)

cr_toks <- tokens(cr_sample_corpus)

immig_toks <- tokens_context(x = cr_toks,
pattern = "immigration", window = 6L, hard_cut = FALSE, verbose = TRUE)

set.seed(42L)
party_nns <- contrast_nns(x = immig_toks,
groups = docvars(immig_toks, 'party'),
pre_trained = cr_glove_subset,
transform = TRUE, transform_matrix = cr_transform,
bootstrap = TRUE, num_bootstraps = 10,
permute = TRUE, num_permutations = 100,
candidates = NULL, N = 20,
verbose = FALSE)
}
\keyword{contrast_nns}
