% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{round_rank}
\alias{round_rank}
\title{Rank vector after rounding}
\usage{
round_rank(x, type = "desc", na.last = TRUE, ties = c("average", "first",
  "last", "random", "max", "min"), round_digits = 7)
}
\arguments{
\item{x}{A numeric, complex, character or logical vector.}

\item{type}{Type of ranking: \code{"desc"} or \code{"asc"} (see Details).}

\item{na.last}{For controlling the treatment of \code{NA}s. If \code{TRUE}, missing
values in the data are put last; if \code{FALSE}, they are put first; if \code{NA},
they are removed; if \code{"keep"} they are kept with rank \code{NA}.}

\item{ties}{A character string specifying how ties are treated (see Details).
Can be abbreviated.}

\item{round_digits}{Value of \code{digits} for \code{\link[=round]{round()}}.}
}
\value{
A numeric vector of the same length as \code{x} with names copied from \code{x}
(unless \code{na.last = NA}, when missing values are removed). The vector is of
integer type unless \code{x} is a long vector or \code{ties = "average"} when it is of
double type (whether or not there are any ties).
}
\description{
Function for ranking vector after rounding.
}
\details{
This is basically a wrapper around \code{\link[=rank]{rank()}} in which \code{x} is
pre-modified by rounding to specific number of digits \code{round_digits}.

\code{type} can have two values: \code{"desc"} for ranking in descending order (rank 1
is given to the biggest value in \code{x}) and \code{"asc"} (rank 1 is given to the
smallest value in \code{x}). Any other value will cause error.
}
\examples{
round_rank(10:1, type = "desc")
round_rank(10:1, type = "asc")

set.seed(334)
x <- 10^(-10) * runif(10)
round_rank(x)

}
