% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elo.R
\name{elo}
\alias{elo}
\alias{rate_elo}
\alias{rank_elo}
\alias{add_elo_ratings}
\alias{elo}
\title{Elo method}
\usage{
rate_elo(cr_data, K = 30, ksi = 400, initial_ratings = 0)

rank_elo(cr_data, K = 30, ksi = 400, initial_ratings = 0,
  keep_rating = FALSE, ties = c("average", "first", "last", "random", "max",
  "min"), round_digits = 7)

add_elo_ratings(cr_data, K = 30, ksi = 400, initial_ratings = 0)

elo(rating1, score1, rating2, score2, K = 30, ksi = 400)
}
\arguments{
\item{cr_data}{Competition results in format ready for
\link[comperes:as_longcr]{as_longcr()}.}

\item{K}{K-factor for Elo formula.}

\item{ksi}{Normalization coefficient for Elo formula.}

\item{initial_ratings}{Initial ratings (see \link[=iterative]{Iterative ratings}).}

\item{keep_rating}{Whether to keep rating column in ranking output.}

\item{ties}{Value for \code{ties} in \code{\link[=round_rank]{round_rank()}}.}

\item{round_digits}{Value for \code{round_digits} in \code{\link[=round_rank]{round_rank()}}.}

\item{rating1}{Rating of player1 before the game.}

\item{score1}{Score of player1 in the game.}

\item{rating2}{Rating of player2 before the game.}

\item{score2}{Score of player2 in the game.}
}
\value{
\code{rate_elo()} returns a \link[tibble:tibble]{tibble} with columns
\code{player} (player identifier) and \code{rating_elo} (Elo
\link[=rating-ranking]{ratings}, based on row order, by the end of competition
results). \strong{Bigger value indicates better player performance}.

\code{rank_elo()} returns a \code{tibble} with columns \code{player}, \code{rating_elo} (if
\code{keep_rating = TRUE}) and \code{ranking_elo} (Elo \link[=rating-ranking]{ranking}
computed with \code{\link[=round_rank]{round_rank()}}).

\code{add_elo_ratings()} returns a \link[comperes:widecr]{widecr} form of \code{cr_data}
with four rating columns added:
\itemize{
\item \strong{rating1Before} - Rating of player1 before the game.
\item \strong{rating2Before} - Rating of player2 before the game.
\item \strong{rating1After} - Rating of player1 after the game.
\item \strong{rating2After} - Rating of player2 after the game.
}

\code{elo()} always returns a matrix with two columns containing ratings after the
game. Rows represent games, columns - players.
}
\description{
Functions to compute \link[=rating-ranking]{rating} and \link[=rating-ranking]{ranking}
using Elo method.
}
\details{
\code{rate_elo()} and \code{add_elo_ratings()} are wrappers for
\code{\link[=rate_iterative]{rate_iterative()}} and \code{\link[=add_iterative_ratings]{add_iterative_ratings()}} correspondingly. Rate
function is based on Elo algorithm of updating ratings:
\enumerate{
\item Probability of player1 (with rating r1) winning against player2 (with
rating r2) is computed based on rating difference and sigmoid function:
\code{P = 1 / (1 + 10^( (r2 - r1) / ksi ) )}. \code{ksi} defines the spread of ratings.
\item Result of the game from player1 perspective is computed based on rule:
\code{S = 1} (if \code{score1} > \code{score2}), \code{S = 0.5} (if \code{score1} == \code{score2}) and
\code{S = 0} (if \code{score1} < \code{score2}).
\item Rating delta is computed: \code{d = K * (S - P)}. The more the \code{K} the more the
delta (with other being equal).
\item New ratings are computed: \code{r1_new = r1 + d}, \code{r2_new = r2 - d}.
}

\code{elo()} function implements this algorithm. It is vectorized over all its
arguments with standard R recycling functionality. \strong{Note} that not this
function is used in \code{rate_elo()} and \code{add_elo_ratings()} because of its not
appropriate output format, but rather its non-vectorized reimplementation is.

Ratings are computed based only on games between players of interest (see
Players) and \code{NA} values.
}
\section{Players}{


\code{comperank} offers a possibility to handle certain set of players. It is done
by having \code{player} column (in \link[comperes:as_longcr]{longcr} format) as factor
with levels specifying all players of interest. In case of factor the result
is returned only for players from its levels. Otherwise - for all present
players.
}

\examples{
# Elo ratings
rate_elo(ncaa2005)

rank_elo(ncaa2005)

rank_elo(ncaa2005, keep_rating = TRUE)

add_elo_ratings(ncaa2005, initial_ratings = 100)

# Elo function
elo((0:12)*100, 1, 0, 0)
elo((0:12)*100, 1, 0, 0, K = 10)
elo((0:12)*10, 1, 0, 0, ksi = 40)

}
\references{
\href{https://en.wikipedia.org/wiki/Elo_rating_system}{Wikipedia
page} for Elo rating system.
}
