context("ICD-9 codes for the Elixhauser score are properly identified")

test_that("Elixhauser, chf, 39891", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "39891"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$chf, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, chf, 40201", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "40201"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$chf, expected = 1)
  expect_equal(object = cs$score, expected = 2)
})
test_that("Elixhauser, chf, 40211", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "40211"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$chf, expected = 1)
  expect_equal(object = cs$score, expected = 2)
})
test_that("Elixhauser, chf, 40291", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "40291"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$chf, expected = 1)
  expect_equal(object = cs$score, expected = 2)
})
test_that("Elixhauser, chf, 40401", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "40401"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$chf, expected = 1)
  expect_equal(object = cs$score, expected = 2)
})
test_that("Elixhauser, chf, 40403", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "40403"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$chf, expected = 1)
  expect_equal(object = cs$score, expected = 3)
})
test_that("Elixhauser, chf, 40411", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "40411"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$chf, expected = 1)
  expect_equal(object = cs$score, expected = 2)
})
test_that("Elixhauser, chf, 40413", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "40413"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$chf, expected = 1)
  expect_equal(object = cs$score, expected = 3)
})
test_that("Elixhauser, chf, 40491", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "40491"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$chf, expected = 1)
  expect_equal(object = cs$score, expected = 2)
})
test_that("Elixhauser, chf, 40493", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "40493"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$chf, expected = 1)
  expect_equal(object = cs$score, expected = 3)
})
test_that("Elixhauser, chf, 4254-4259", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "4254"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$chf, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "4255"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$chf, expected = 1)
  expect_equal(object = cs$alcohol, expected = 1)
  expect_equal(object = cs$score, expected = 2)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "4256"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$chf, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "4257"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$chf, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "4258"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$chf, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "4259"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$chf, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, chf, 428", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "428"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$chf, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})

test_that("Elixhauser, carit, 4260", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "4260"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$carit, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, carit, 42613", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "42613"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$carit, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, carit, 4267", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "4267"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$carit, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, carit, 4269", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "4269"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$carit, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, carit, 42610", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "42610"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$carit, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, carit, 42612", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "42612"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$carit, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, carit, 4270-4274", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "4270"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$carit, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "4271"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$carit, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "4272"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$carit, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "4273"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$carit, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "4274"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$carit, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, carit, 4276-4279", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "4276"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$carit, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "4277"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$carit, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "4278"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$carit, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "4279"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$carit, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, carit, 7850", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "7850"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$carit, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, carit, 99601", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "99601"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$carit, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, carit, 99604", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "99604"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$carit, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, carit, V450", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "V450"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$carit, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, carit, V533", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "V533"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$carit, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})

test_that("Elixhauser, valv, 0932", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "0932"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$valv, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, valv, 394-397", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "394"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$valv, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "395"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$valv, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "396"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$valv, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "397"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$valv, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, valv, 424", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "424"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$valv, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, valv, 7463-7466", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "7463"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$valv, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "7464"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$valv, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "7465"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$valv, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "7466"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$valv, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, valv, V422", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "V422"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$valv, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, valv, V433", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "V433"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$valv, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})

test_that("Elixhauser, pcd, 4150", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "4150"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$pcd, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, pcd, 4151", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "4151"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$pcd, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, pcd, 416", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "416"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$pcd, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, pcd, 4170", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "4170"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$pcd, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, pcd, 4178", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "4178"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$pcd, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, pcd, 4179", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "4179"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$pcd, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})

test_that("Elixhauser, pvd, 0930", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "0930"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$pvd, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, pvd, 4373", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "4373"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$pvd, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, pvd, 440", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "440"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$pvd, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, pvd, 441", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "441"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$pvd, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, pvd, 4431-4439", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "4431"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$pvd, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "4432"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$pvd, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "4433"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$pvd, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "4434"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$pvd, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "4435"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$pvd, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "4436"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$pvd, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "4437"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$pvd, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "4438"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$pvd, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "4439"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$pvd, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, pvd, 4471", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "4471"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$pvd, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, pvd, 5571", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "5571"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$pvd, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, pvd, 5579", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "5579"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$pvd, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, pvd, V434", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "V434"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$pvd, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})

test_that("Elixhauser, hypunc, 401", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "401"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$hypunc, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})

test_that("Elixhauser, hypc, 402-405", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "402"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$hypc, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "403"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$hypc, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "404"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$hypc, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "405"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$hypc, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})

test_that("Elixhauser, para, 3341", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "3341"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$para, expected = 1)
  expect_equal(object = cs$score, expected = 2)
})
test_that("Elixhauser, para, 342", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "342"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$para, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, para, 343", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "343"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$para, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})

test_that("Elixhauser, para, 3440-3446", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "3440"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$para, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "3441"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$para, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "3442"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$para, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "3443"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$para, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "3444"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$para, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "3445"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$para, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "3446"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$para, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, para, 3449", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "3449"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$para, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})


test_that("Elixhauser, ond, 3319", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "3319"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$ond, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, ond, 3320", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "3320"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$ond, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, ond, 3321", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "3321"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$ond, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, ond, 3334", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "3334"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$ond, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, ond, 3335", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "3335"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$ond, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, ond, 33392", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "33392"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$ond, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, ond, 334-335", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "334"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$ond, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "335"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$ond, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, ond, 3362", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "3362"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$ond, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, ond, 340", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "340"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$ond, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, ond, 341", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "341"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$ond, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, ond, 345", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "345"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$ond, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, ond, 3481", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "3481"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$ond, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, ond, 3483", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "3483"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$ond, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, ond, 7803", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "7803"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$ond, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, ond, 7843", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "7843"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$ond, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})

test_that("Elixhauser, cpd, 4168", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "4168"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$cpd, expected = 1)
  expect_equal(object = cs$score, expected = 2)
})
test_that("Elixhauser, cpd, 4169", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "4169"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$cpd, expected = 1)
  expect_equal(object = cs$score, expected = 2)
})
test_that("Elixhauser, cpd, 490-505", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "490"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$cpd, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "491"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$cpd, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "492"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$cpd, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "493"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$cpd, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "494"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$cpd, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "495"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$cpd, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "496"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$cpd, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "497"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$cpd, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "498"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$cpd, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "499"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$cpd, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "500"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$cpd, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "501"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$cpd, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "502"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$cpd, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "503"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$cpd, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "504"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$cpd, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "505"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$cpd, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, cpd, 5064", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "5064"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$cpd, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, cpd, 5081", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "5081"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$cpd, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, cpd, 5088", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "5088"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$cpd, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})


test_that("Elixhauser, diabunc, 2500-2503", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "2500"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$diabunc, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "2501"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$diabunc, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "2502"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$diabunc, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "2503"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$diabunc, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})

test_that("Elixhauser, diabc, 2504-2509", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "2504"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$diabc, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "2505"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$diabc, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "2506"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$diabc, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "2507"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$diabc, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "2508"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$diabc, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "2509"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$diabc, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})

test_that("Elixhauser, hypothy, 2409", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "2409"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$hypothy, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, hypothy, 243", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "243"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$hypothy, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, hypothy, 244", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "244"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$hypothy, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, hypothy, 2461", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "2461"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$hypothy, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, hypothy, 2468", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "2468"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$hypothy, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})

test_that("Elixhauser, rf, 40301", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "40301"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$rf, expected = 1)
  expect_equal(object = cs$score, expected = 2)
})
test_that("Elixhauser, rf, 40311", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "40311"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$rf, expected = 1)
  expect_equal(object = cs$score, expected = 2)
})
test_that("Elixhauser, rf, 40391", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "40391"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$rf, expected = 1)
  expect_equal(object = cs$score, expected = 2)
})
test_that("Elixhauser, rf, 40402", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "40402"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$rf, expected = 1)
  expect_equal(object = cs$score, expected = 2)
})
test_that("Elixhauser, rf, 40402", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "40402"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$rf, expected = 1)
  expect_equal(object = cs$score, expected = 2)
})
test_that("Elixhauser, rf, 40403", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "40403"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$rf, expected = 1)
  expect_equal(object = cs$score, expected = 3)
})
test_that("Elixhauser, rf, 40412", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "40412"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$rf, expected = 1)
  expect_equal(object = cs$score, expected = 2)
})
test_that("Elixhauser, rf, 40413", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "40413"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$rf, expected = 1)
  expect_equal(object = cs$score, expected = 3)
})
test_that("Elixhauser, rf, 40492", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "40492"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$rf, expected = 1)
  expect_equal(object = cs$score, expected = 2)
})
test_that("Elixhauser, rf, 40493", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "40493"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$rf, expected = 1)
  expect_equal(object = cs$score, expected = 3)
})
test_that("Elixhauser, rf, 585", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "585"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$rf, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, rf, 586", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "586"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$rf, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, rf, 5880", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "5880"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$rf, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, rf, V420", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "V420"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$rf, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, rf, V451", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "V451"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$rf, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, rf, V56", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "V56"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$rf, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})

test_that("Elixhauser, ld, 07022", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "07022"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$ld, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, ld, 07023", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "07023"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$ld, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, ld, 07032", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "07032"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$ld, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, ld, 07033", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "07033"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$ld, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, ld, 07044", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "07044"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$ld, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, ld, 07054", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "07054"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$ld, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, ld, 0706", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "0706"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$ld, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, ld, 0709", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "0709"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$ld, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, ld, 4560-4562", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "4560"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$ld, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "4561"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$ld, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "4562"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$ld, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, ld, 570", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "570"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$ld, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, ld, 571", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "571"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$ld, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, ld, 5722-5728", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "5722"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$ld, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "5723"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$ld, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "5724"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$ld, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "5725"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$ld, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "5726"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$ld, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "5727"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$ld, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "5728"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$ld, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, ld, 5733", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "5733"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$ld, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, ld, 5734", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "5734"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$ld, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, ld, 5738", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "5738"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$ld, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, ld, 5739", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "5739"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$ld, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, ld, V427", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "V427"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$ld, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})

test_that("Elixhauser, pud, 5317", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "5317"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$pud, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, pud, 5319", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "5319"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$pud, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, pud, 5327", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "5327"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$pud, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, pud, 5329", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "5329"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$pud, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, pud, 5337", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "5337"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$pud, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, pud, 5339", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "5339"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$pud, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, pud, 5347", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "5347"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$pud, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, pud, 5349", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "5349"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$pud, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})

test_that("Elixhauser, aids, 042-044", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "042"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$aids, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "043"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$aids, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "044"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$aids, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})

test_that("Elixhauser, lymph, 200-202", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "200"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$lymph, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "201"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$lymph, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "202"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$lymph, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, lymph, 2030", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "2030"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$lymph, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, lymph, 2386", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "2386"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$lymph, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})

test_that("Elixhauser, metacanc, 196-199", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "196"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$metacanc, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "197"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$metacanc, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "198"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$metacanc, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "199"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$metacanc, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})

test_that("Elixhauser, solidtum, 140-172", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "140"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$solidtum, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "141"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$solidtum, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "142"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$solidtum, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "143"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$solidtum, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "144"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$solidtum, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "145"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$solidtum, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "146"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$solidtum, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "147"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$solidtum, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "148"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$solidtum, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "149"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$solidtum, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "150"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$solidtum, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "151"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$solidtum, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "152"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$solidtum, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "153"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$solidtum, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "154"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$solidtum, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "155"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$solidtum, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "156"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$solidtum, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "157"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$solidtum, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "158"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$solidtum, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "159"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$solidtum, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "160"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$solidtum, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "161"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$solidtum, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "162"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$solidtum, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "163"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$solidtum, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "164"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$solidtum, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "165"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$solidtum, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "166"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$solidtum, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "167"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$solidtum, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "168"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$solidtum, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "169"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$solidtum, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "170"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$solidtum, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "171"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$solidtum, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "172"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$solidtum, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, solidtum, 174", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "174"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$solidtum, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, solidtum, 195", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "195"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$solidtum, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})

test_that("Elixhauser, rheumd, 446", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "446"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$rheumd, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, rheumd, 7010", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "7010"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$rheumd, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, rheumd, 7100-7104", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "7100"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$rheumd, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "7101"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$rheumd, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "7102"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$rheumd, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "7103"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$rheumd, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "7104"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$rheumd, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, rheumd, 7108", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "7108"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$rheumd, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, rheumd, 7109", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "7109"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$rheumd, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, rheumd, 7112", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "7112"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$rheumd, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, rheumd, 714", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "714"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$rheumd, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, rheumd, 7193", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "7193"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$rheumd, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, rheumd, 720", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "720"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$rheumd, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, rheumd, 725", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "725"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$rheumd, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, rheumd, 7285", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "7285"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$rheumd, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, rheumd, 72889", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "72889"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$rheumd, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, rheumd, 72930", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "72930"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$rheumd, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})

test_that("Elixhauser, coag, 286", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "286"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$coag, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, coag, 2871", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "2871"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$coag, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, coag, 2873-2875", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "2873"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$coag, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "2874"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$coag, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "2875"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$coag, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})

test_that("Elixhauser, obes, 2780", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "2780"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$obes, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})

test_that("Elixhauser, wloss, 260-263", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "260"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$wloss, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "261"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$wloss, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "262"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$wloss, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "263"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$wloss, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, wloss, 7832", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "7832"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$wloss, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, wloss, 7994", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "7994"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$wloss, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})

test_that("Elixhauser, fed, 2536", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "2536"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$fed, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, fed, 276", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "276"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$fed, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})

test_that("Elixhauser, blane, 2800", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "2800"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$blane, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})

test_that("Elixhauser, dane, 2801-2809", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "2801"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$dane, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "2802"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$dane, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "2803"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$dane, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "2804"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$dane, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "2805"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$dane, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "2806"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$dane, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "2807"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$dane, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "2808"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$dane, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "2809"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$dane, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, dane, 281", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "281"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$dane, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})

test_that("Elixhauser, alcohol, 2652", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "2652"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$alcohol, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, alcohol, 2911-2913", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "2911"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$alcohol, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "2912"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$alcohol, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "2913"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$alcohol, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, alcohol, 2915-2919", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "2915"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$alcohol, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "2916"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$alcohol, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "2917"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$alcohol, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "2918"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$alcohol, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "2919"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$alcohol, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, alcohol, 3030", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "3030"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$alcohol, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, alcohol, 3039", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "3039"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$alcohol, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, alcohol, 3050", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "3050"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$alcohol, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, alcohol, 3575", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "3575"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$alcohol, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, alcohol, 4255", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "4255"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$alcohol, expected = 1)
  expect_equal(object = cs$score, expected = 2)
})
test_that("Elixhauser, alcohol, 5353", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "5353"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$alcohol, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, alcohol, 5710-5713", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "5710"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$alcohol, expected = 1)
  expect_equal(object = cs$score, expected = 2)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "5711"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$alcohol, expected = 1)
  expect_equal(object = cs$score, expected = 2)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "5712"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$alcohol, expected = 1)
  expect_equal(object = cs$score, expected = 2)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "5713"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$alcohol, expected = 1)
  expect_equal(object = cs$score, expected = 2)
})
test_that("Elixhauser, alcohol, 980", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "980"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$alcohol, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, alcohol, V113", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "V113"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$alcohol, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})

test_that("Elixhauser, drug, 292", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "292"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$drug, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, drug, 304", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "304"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$drug, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, drug, 3052-3059", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "3052"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$drug, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "3053"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$drug, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "3054"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$drug, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "3055"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$drug, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "3056"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$drug, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "3057"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$drug, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "3058"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$drug, expected = 1)
  expect_equal(object = cs$score, expected = 1)
  cs <- comorbidity(x = data.frame(id = "ID1", code = "3059"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$drug, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, drug, V6542", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "V6542"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$drug, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})

test_that("Elixhauser, psycho, 2938", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "2938"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$psycho, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, psycho, 295", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "295"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$psycho, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, psycho, 29604", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "29604"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$psycho, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, psycho, 29614", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "29614"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$psycho, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, psycho, 29644", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "29644"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$psycho, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, psycho, 29654", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "29654"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$psycho, expected = 1)
  expect_equal(object = cs$score, expected = 2)
})
test_that("Elixhauser, psycho, 297", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "297"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$psycho, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, psycho, 298", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "298"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$psycho, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})

test_that("Elixhauser, depre, 2962", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "2962"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$depre, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, depre, 2963", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "2963"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$depre, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, depre, 2965", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "2965"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$depre, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, depre, 3004", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "3004"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$depre, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, depre, 309", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "309"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$depre, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
test_that("Elixhauser, depre, 311", {
  cs <- comorbidity(x = data.frame(id = "ID1", code = "311"), id = "id", code = "code", score = "elixhauser", icd = "icd9", assign0 = FALSE)
  expect_equal(object = cs$depre, expected = 1)
  expect_equal(object = cs$score, expected = 1)
})
