% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/other_functions.R
\name{copy.attributes}
\alias{copy.attributes}
\title{Copy attributes between two data frames}
\usage{
copy.attributes(source, target)
}
\arguments{
\item{source}{A data frame to copy attributes from.}

\item{target}{A data frame to copy attributes to.}
}
\value{
The data frame in the \code{target} parameter, with updated
attributes from \code{source}.
}
\description{
A function to copy column attributes from one
data frame to another.  The function will copy all attributes attached
to each column.  The column order does not matter, and the data frames
do not need identical structures. The matching occurs by column name,
not position.  Any existing attributes on the target data frame
that do not match the source data frame will be retained unaltered.
}
\examples{
# Prepare data
dat1 <- mtcars
dat2 <- mtcars

# Set labels for dat1
labels(dat1) <- list(mpg = "Miles Per Gallon",
                     cyl = "Cylinders",
                     disp = "Displacement")

# Copy labels from dat1 to dat2
dat2 <- copy.attributes(dat1, dat2)

# View results
labels(dat2)
# $mpg
# [1] "Miles Per Gallon"
#
# $cyl
# [1] "Cylinders"
#
# $disp
# [1] "Displacement"
}
\seealso{
Other overrides: 
\code{\link{labels.data.frame}()},
\code{\link{sort.data.frame}()}
}
\concept{overrides}
