% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recursiveiter.R
\name{recursiveiter}
\alias{recursiveiter}
\title{Factory of Iterators defined by Recursive Transition Functions}
\usage{
recursiveiter(nextFunc, prevFunc, firstFunc, lastFunc, ...)
}
\arguments{
\item{nextFunc, prevFunc}{Functions that take the iterator state and the parameters \code{...} and returns the next or previous state}

\item{firstFunc, lastFunc}{Functions that take the parameters \code{...}
and returns the first or last state of the iteration}

\item{...}{additional parameters of the iterator}
}
\value{
iterator object
}
\description{
This is a constructor for custom iterator objects.
It requires four functions, "next", "prev", "first", and "last", and
additional parameters.

The state of the constructor is characterized by the variable \code{i}.
The "next" and "prev" function must take \code{i} and the parameters
and return the next and previous state variables respectively.  The behavior where there is no more state left is arbitrary.

The "first" and "last" functions must take the additional parameters and
return the initial and last state variables respectively.

The created object is an iterator of class \code{recursiveiter}, which inherits
\code{abstractiter} and \code{iter}.
It can be used with \code{\link[foreach]{foreach}} and accepts \code{\link{as.list}} conversion.
}
\examples{
fibiter <- recursiveiter(
  nextFunc = function(i) if (length(i)==1 && i==0) 1 else
                         if (length(i)==1 && i==1) c(1,1) else
                         c(sum(i), i[1]),
  prevFunc = NULL, firstFunc = function() 0, lastFunc = function() Inf)
for (k in 1:20) cat(nextElem(fibiter)[1], "")
}
