% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colour_values.R
\name{color_values_rgb}
\alias{color_values_rgb}
\title{Color Values RGB}
\usage{
color_values_rgb(x, palette = "viridis", na_colour = "#808080FF",
  alpha = 255, include_alpha = TRUE)
}
\arguments{
\item{x}{vector of values to map to a colour}

\item{palette}{colour palette. See details and examples}

\item{na_colour}{hex string colour to use for NA values in the form \code{#RRGGBBAA}.}

\item{alpha}{optional. Single value in [0,255] applied to all colours, or
a vector of numeric values the same length as \code{x}. The numeric vector
will be scaled into the range [0,255].
If a matrix palette is supplied this argument is ignored.}

\item{include_alpha}{logical indicating if the returned hex or matrix should include
the alpha values. Defaults to \code{TRUE}}
}
\description{
maps colours to values, returning a matrix of RGB(A) values
}
\seealso{
colour_values_rgb
}
