% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/avgHex.R
\name{avgHex}
\alias{avgHex}
\title{avgHex}
\usage{
avgHex(df, hex_col, group_col)
}
\arguments{
\item{df}{A data frame with columns for hex color values and group labels.}

\item{hex_col}{The name of the column containing hex color values. Default is "hex".}

\item{group_col}{The name of the column containing group labels. Default is "group".}
}
\value{
A data frame with the group labels and their corresponding average hex colors.
}
\description{
Average Hex Colors per Group. This function takes a data frame
with two columns: one for the hex color values and another for
the group labels. It calculates the average color for each
group and returns a data frame with the group labels and their
corresponding average hex colors.
}
\examples{
df <- data.frame(
  hex = c("#FF0000", "#00FF00", "#0000FF", "#FFFF00", "#FF00FF"),
  group = c(1, 1, 2, 2, 3)
)

avgHex(df, hex_col = "hex", group_col = "group")
}
