% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colorspace.R
\name{whitepoint}
\alias{whitepoint}
\title{Access or Modify the Whitepoint}
\usage{
whitepoint(white, ...)
}
\arguments{
\item{white, ...}{Either missing (to query the whitepoint) or
\code{NULL} or a specification of the XYZ coordinates of the whitepoint
(to set the whitepoint, see examples). \code{NULL} corresponds to
CIE D65 with XYZ coordinates 95.047, 100.000, 108.883.}
}
\value{
\code{whitepoint} returns an XYZ color object for the whitepoint
(invisibly in case a new whitepoint was set).
}
\description{
This function can be used to control the single global whitepoint
that affects all color conversions within the package (that require
a whitepoint, i.e., go through XYZ).
}
\examples{
# query current whitepoint (D65 by default)
whitepoint()

# Illuminant E 
whitepoint(XYZ(100, 100, 100))

# equivalently
whitepoint(100, 100, 100)
whitepoint(c(100, 100, 100))
whitepoint(cbind(100, 100, 100))

whitepoint()

## reset
whitepoint(NULL)
whitepoint()
}
\seealso{
\code{\link{XYZ}} and \link{color-class}.
}
\keyword{color}
