% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cointReg.R
\docType{package}
\name{cointReg-package}
\alias{cointReg-package}
\title{The cointReg package}
\description{
Parameter Estimation and Inference in a Cointegrating Regression
}
\details{
See the vignette:\cr
\code{vignette("cointReg")}

See the DESCRIPTION:\cr
\code{help(package = cointReg)}

See the README:\cr
\url{https://github.com/aschersleben/cointReg/blob/master/README.md}

Open the package documentation page:\cr
\code{package?cointReg}

Further information and bug reporting:\cr
\url{https://github.com/aschersleben/cointReg}
}
\section{Functions}{

\itemize{
  \item \code{\link{cointReg}(method = c("FM", "D", "IM"), ...)}\cr
        General function to estimate parameters of
        the given model. Three methods are possible: FM-OLS, D-OLS and
        IM-OLS; they can be directly choosen by using one of the following
        functions:
  \itemize{
    \item \code{\link{cointRegFM}(x, y, deter,
          kernel = c("ba", "pa", "qs", "tr"), bandwidth = c("and", "nw"),
          demeaning = FALSE, check = TRUE, ...)}
    \item \code{\link{cointRegD}(x, y, deter,
          kernel = c("ba", "pa", "qs", "tr"), bandwidth = c("and", "nw"),
          n.lead = NULL, n.lag = NULL, kmax = c("k4", "k12"),
          info.crit = c("AIC", "BIC"), demeaning = FALSE, check = TRUE, ...)}
    \item \code{\link{cointRegIM}(x, y, deter, selector = 1, t.test = TRUE,
          kernel = c("ba", "pa", "qs", "tr"), bandwidth = c("and", "nw"),
          check = TRUE, ...)}
  }
  \item \code{\link[=print.cointReg]{print}}\cr
        Print clear results.
  \item \code{\link[=plot.cointReg]{plot}}\cr
        Plot the residuals of a \code{cointReg} model.
  \item Helper functions:
  \itemize{
    \item Checking inputs and arguments:\cr
          \code{\link{checkObject}}, \code{\link{checkVars}}
    \item Calculation of bandwidth and long run variance:\cr
          \code{\link{getBandwidth}}, \code{\link{getBandwidthAnd}},
          \code{\link{getBandwidthNW}}\cr
          \code{\link{getLongRunVar}}, \code{\link{getLongRunWeights}}
    \item Additional D-OLS functions:\cr
          \code{\link{getLeadLag}}, \code{\link{makeLeadLagMatrix}},
          \code{\link{getModD}},  \code{\link{checkDoptions}}
  }
}
}

