% --- Source file: ./man/Salmon.Rd ---
% File src/library/codep/man/Salmon.Rd
% Part of the R package, http://www.R-project.org
% Copyright 2009 Guenard, Guillaume and Legendre, Pierre
% Distributed under GPL 2 or later
\name{Salmon}
\alias{Salmon}
\title{St-Marguerite Juvenile Atlantic salmon (parr) dataset.}
\description{
  A 1520m transect of the St-Marguerite River, Quebec, Canada.
}
\usage{
data(Salmon)
}
\format{
  A 76 x 5 dataframe.
}
\details{
  Contains (1) the position on the segment upstream site
  \sQuote{Bardsville} (48d23m01.59s N ; 70d12m10.05s W), (2) the
  number of Parr (age I+ and II+) observed in the segment, (3) the
  mean water depth estimated across the segment (m), (4) the mean
  current velocity estimated across the segment (m/s), and (5) The
  mean substrate size (mm). Water depth, current velocity, and mean
  substrate size were estimates in 76 segments of 20m. Sampling took
  place on 7 July 2002.
}
\references{
  Guenard, G., Legendre, P., Boisclair, D., and Bilodeau, M. In press.
  Multiscale codependence analysis: an integrated approach to analyse
  relationships. Ecology
}
\seealso{
  Bouchard, J. and Boisclair, D. 2008. The relative importance of local,
  lateral, and longitudinal variables on the development of habitat
  quality models for a river. Can. J. Fish. Aquat. Sci. 65: 61-73
}
\examples{
data(Salmon)
}
\author{ Daniel Boisclair, Departement de sciences biologiques,
  Universite de Montreal, Montreal, Quebec, Canada. }
