% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coda4microbiome_functions.R
\name{explore_logratios}
\alias{explore_logratios}
\title{explore_logratios}
\usage{
explore_logratios(
  x,
  y,
  decreasing = TRUE,
  measure = "AUC",
  covar = NULL,
  shownames = FALSE,
  maxrow = 15,
  maxcol = 15,
  showtitle = TRUE,
  mar = c(0, 0, 1, 0)
)
}
\arguments{
\item{x}{abundance matrix or data frame (rows are samples, columns are variables (taxa))}

\item{y}{outcome (binary or continuous); data type: numeric, character or factor vector}

\item{decreasing}{order of importance (default = TRUE)}

\item{measure}{association measures "AUC", "Pearson","Spearman", "glm" (default = "AUC")}

\item{covar}{data frame with covariates (default = NULL)}

\item{shownames}{logical, if TRUE, shows the names of the variables in the rows of the plot (default = FALSE)}

\item{maxrow}{maximum number of rows to display in the plot (default = 15)}

\item{maxcol}{maximum number of columns to display in the plot (default = 15)}

\item{showtitle}{logical, if TRUE, shows the title of the plot (default = TRUE)}

\item{mar}{mar numerical vector of the form c(bottom, left, top, right) which gives the number of lines of margin to be specified on the four sides of the plot (default mar=c(0,0,1,0))}
}
\value{
list with "max log-ratio","names max log-ratio", "order of importance",
"name of most important variables", "association log-ratio with y" and
"top log-ratios plot"
}
\description{
Explores the association of each log-ratio with the outcome.
Summarizes the importance of each variable (taxa) as the aggregation of
the association measures of those log-ratios involving the variable. The output includes a plot
of the association of the log-ratio with the outcome where the variables (taxa) are ranked by importance
}
\examples{

data(HIV, package = "coda4microbiome")

explore_logratios(x_HIV,y_HIV)

}
\author{
M. Calle - T. Susin
}
