% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basis.R
\name{ilr_basis}
\alias{ilr_basis}
\alias{olr_basis}
\title{Isometric/Orthonormal log-ratio basis for log-transformed compositions.}
\usage{
ilr_basis(dim, type = "default")

olr_basis(dim, type = "default")
}
\arguments{
\item{dim}{number of components}

\item{type}{if different than `pivot` (pivot balances) or `cdp` (codapack balances) default balances are returned, which computes a triangular Helmert matrix as defined by Egozcue et al., 2013.}
}
\value{
matrix
}
\description{
By default the basis of the clr-given by Egozcue et al., 2013
Build an isometric log-ratio basis for a composition with k+1 parts
\deqn{h_i = \sqrt{\frac{i}{i+1}} \log\frac{\sqrt[i]{\prod_{j=1}^i x_j}}{x_{i+1}}}{%
h[i] = \sqrt(i/(i+1)) ( log(x[1] \ldots x[i])/i - log(x[i+1]) )}
for \eqn{i \in 1\ldots k}.
}
\details{
Modifying parameter type (pivot or cdp) other ilr/olr basis can be generated
}
\examples{
ilr_basis(5)
}
\references{
Egozcue, J.J., Pawlowsky-Glahn, V., Mateu-Figueras, G. and Barceló-Vidal C. (2003).
\emph{Isometric logratio transformations for compositional data analysis}.
Mathematical Geology, \strong{35}(3) 279-300
}
