% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basis.R
\name{hk_ext}
\alias{hk_ext}
\alias{hk_ext_z}
\alias{hk_ext_z_j_opt}
\title{Calculate values related to Extended Hanson--Koopmans tolerance bounds}
\usage{
hk_ext_z(n, i, j, p, conf)

hk_ext_z_j_opt(n, p, conf)
}
\arguments{
\item{n}{the sample size}

\item{i}{the first order statistic (1 <= i < j)}

\item{j}{the second order statistic (i < j <= n)}

\item{p}{the content of the tolerance bound (normally 0.90 or 0.99)}

\item{conf}{the confidence level (normally 0.95)}
}
\value{
For \code{hk_ext_z}, the return value is a numeric value representing
the parameter z (denoted as k in CMH-17-1G).

For \code{hk_ext_z_j_opt}, the return value is named list containing
\code{z} and \code{k}. The former is the value of z, as defined by
Vangel (1994), and the latter is the corresponding order statistic.
}
\description{
Calculates values related to Extended Hanson--Koopmans tolerance bounds
as described by Vangel (1994).
}
\details{
Hanson (1964) presents a nonparametric method for determining
tolerance bounds based on consecutive order statistics.
Vangel (1994) extends this method using non-consecutive order statistics.

The extended Hanson--Koopmans method calculates a tolerance bound
(basis value) based on two order statistics and a weighting value
\code{z}. The value of \code{z} is based on the sample size, which
order statistics are selected, the desired content of the tolerance
bond and the desired confidence level.

The function \code{hk_ext_z} calculates the weighting variable \code{z}
based on selected order statistics \code{i} and \code{j}. Based on this
value \code{z}, the tolerance bound can be calculated as:

\deqn{S = z X_{(i)} + (1 - z) X_{(j)}}{S = z X(i) + (1 - z) X(j)}

Where \eqn{X_{(i)}}{X(i)} and \eqn{X_{(j)}}{X(j)} are the \code{i-th}
and \code{j-th} ordered observation.

The function \code{hk_ext_z_j_opt} determines the value of \code{j} and
the corresponding value of \code{z}, assuming \code{i=1}. The value
of \code{j} is selected such that the computed tolerance limit is
nearest to the desired population quantile for a standard normal
distribution when the order statistics are equal to the expected
value of the order statistics for the standard normal distribution.
}
\examples{
# The factors from Table 1 of Vangel (1994) can be recreated
# using the hk_ext_z function. For the sample size n=21,
# the median is the 11th ordered observation. The factor
# required for calculating the tolerance bound with a content
# of 0.9 and a confidence level of 0.95 based on the median
# and first ordered observation can be calculated as follows.
hk_ext_z(n = 21, i = 1, j = 11, p = 0.9, conf = 0.95)

## [1] 1.204806

# The hk_ext_z_j_opt function can be used to refine this value
# of z by finding an optimum value of j, rather than simply
# using the median. Here, we find that the optimal observation
# to use is the 10th, not the 11th (which is the median).
hk_ext_z_j_opt(n = 21, p = 0.9, conf = 0.95)

## $z
## [1] 1.217717
##
## $j
## [1] 10

}
\references{
M. Vangel, “One-Sided Nonparametric Tolerance Limits,”
Communications in Statistics - Simulation and Computation,
vol. 23, no. 4. pp. 1137–1154, 1994.

D. L. Hanson and L. H. Koopmans,
“Tolerance Limits for the Class of Distributions with Increasing
Hazard Rates,” The Annals of Mathematical Statistics,
vol. 35, no. 4. pp. 1561–1570, 1964.
}
\seealso{
\code{\link[=basis_hk_ext]{basis_hk_ext()}}
}
