% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quicklook.R
\name{quicklook}
\alias{quicklook}
\title{Create a quicklook of NetCDF data}
\usage{
quicklook(
  config,
  filelist,
  outpath = getwd(),
  jpeg_quality = 75,
  dpi = 72,
  iwidth = 720,
  logo = TRUE,
  copyright = TRUE,
  bluemarble = FALSE
)
}
\arguments{
\item{config}{filename of configuration file. This may include the directory
(character).}

\item{filelist}{list of NetCDF file to create plots from (character).}

\item{outpath}{directory in which to save the output files.
(character).}

\item{jpeg_quality}{jpeg quality for the image in percent, see \link[grDevices:png]{grDevices::jpeg()}}

\item{dpi}{resolution of the image in dots per inch, see \link[grDevices:png]{grDevices::jpeg()}}

\item{iwidth}{width of the resulting image in pixels, see \link[grDevices:png]{grDevices::jpeg()}}

\item{logo}{logical; should the cmsaf logo be added to the plot?}

\item{copyright}{logical; should the copyright text be added to the plot?}

\item{bluemarble}{logical; should the data be plotted onto a NASA bluemarble (only available for MSG/Seviri based data)?
Due to data size this option is not available for the cmsafvis package on CRAN. Please have a look at
our website https://www.cmsaf.eu/R_toolbox}
}
\value{
A jpeg file with the same name as the original NetCDF file.
}
\description{
The function creates a plot of the variables in NetCDF file(s) specified in the config file.
Only NetCDF files that conform to the \href{https://www.cmsaf.eu/EN/Products/NamingConvention/Naming_Convention_node.html}{CMSAF naming convention} are supported.
}
\examples{
## Create an example NetCDF file with a similar structure as used by CM
## SAF. The file is created with the ncdf4 package.  Alternatively
## example data can be freely downloaded here: <https://wui.cmsaf.eu/>

library(ncdf4)

## create some (non-realistic) example data

lon <- seq(5, 15, 0.5)
lat <- seq(45, 55, 0.5)
time <- c(as.Date("2000-01-01"))
origin <- as.Date("1983-01-01 00:00:00")
time <- as.numeric(difftime(time, origin, units = "hour"))
data <- array(1:441, dim = c(21, 21, 1))

## create example NetCDF
infile1 <- file.path(tempdir(), "SISmm200001010000003231000101MA.nc")

x <- ncdim_def(name = "lon", units = "degrees_east", vals = lon)
y <- ncdim_def(name = "lat", units = "degrees_north", vals = lat)
t1 <- ncdim_def(name = "time", units = "hours since 1983-01-01 00:00:00",
 vals = time[1], unlim = TRUE)
var1 <- ncvar_def("SIS", "W m-2", list(x, y, t1), -1, prec = "short")
vars1 <- list(var1)
ncnew1 <- nc_create(infile1, vars1)
ncvar_put(ncnew1, var1, data[,,1])
ncatt_put(ncnew1, "lon", "standard_name", "longitude", prec = "text")
ncatt_put(ncnew1, "lat", "standard_name", "latitude", prec = "text")
nc_close(ncnew1)

config_path <- system.file(
"extdata",
"quicklook_config.yml",
package = "cmsafvis",
mustWork = TRUE
)
## Create quicklooks to tempdir
quicklook(config_path, list.files(tempdir(), "SIS", full.names = TRUE), outpath = tempdir())
}
