% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RCode.r
\name{LogLike1}
\alias{LogLike1}
\title{Compute the Log-Likelihood for the Model}
\usage{
LogLike1(param)
}
\arguments{
\item{param}{A numeric vector of model parameters: \code{alpha1}, \code{beta1}, \code{alpha2}, \code{beta2}, where
the first two are for the first event and the next two are for the second event.}
}
\value{
A single numeric value representing the negative log-likelihood.
}
\description{
Computes the negative log-likelihood of the Cmpp model given parameters and the initialized data.
The log-likelihood considers Gompertz distributions for competing risks.
}
\details{
This function requires the data to be initialized using \code{Initialize} before being called.
The log-likelihood is based on survival probabilities derived from the Gompertz distributions.
}
\examples{
library(cmpp)
data("fertility_data")
Nam <- names(fertility_data)
fertility_data$Education
datt <- make_Dummy(fertility_data, features = c("Education"))
datt <- datt$New_Data 
datt['Primary_Secondary'] <- datt$`Education:2`
datt['Higher_Education'] <- datt$`Education:3`
datt$`Education:2` <- datt$`Education:3` <- NULL
datt2 <- make_Dummy(datt, features = 'Event')$New_Data
d1 <- datt2$`Event:2`
d2 <- datt2$`Event:3`
feat <- datt2[c('age', 'Primary_Secondary', 'Higher_Education')] |> 
   data.matrix()
timee <- datt2[['time']]
Initialize(feat, timee, d1, d2, 1e-10)
param <- c(0.01, 0.01, 0.01, 0.01)
LogLike1(param)
}
