% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cmahalanobis.R
\name{pvaluescsore}
\alias{pvaluescsore}
\title{Calculate the p_values matrix for each species, using Sorensen-Dice distance as a base.}
\usage{
pvaluescsore(
  dataset,
  formula,
  pvalue.method = "chisq",
  num.permutations = 100,
  num.bootstraps = 10,
  plot = TRUE
)
}
\arguments{
\item{dataset}{A dataframe.}

\item{formula}{A factor which you want to calculate Sorensen-Dice distance.}

\item{pvalue.method}{A p_value method used to calculate the matrix, the default value is "chisq". Other methods are "permutation" and "bootstrap".}

\item{num.permutations}{Number of permutation to specify if you select "permutation" in "pvalue.method". The default value is 100.}

\item{num.bootstraps}{Number of bootstrap to specify if you select "bootstrap" in "p_value method". The default value is 10.}

\item{plot}{if TRUE, plot the p_values heatmap. The default value is TRUE.}
}
\value{
A list containing a matrix of p_values and, optionally, the plot.
}
\description{
This function takes a dataset, a factor, a p_value method, number of bootstraps and permutation when necessary, and returns a p_values matrix between each pair of species and a plot if the user select TRUE using Sorensen-Dice distance for the distances calculation.
}
\examples{
# Calculate p_values of "Species" variable in iris dataset
pvaluescsore(iris,~Species, pvalue.method = "chisq", num.permutations = 100, num.bootstraps = 10)
# Calculate p_values of "am" variable in mtcars dataset
pvaluescsore(mtcars,~am, pvalue.method = "chisq", num.permutations = 100, num.bootstraps = 10)
}
