% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cmahalanobis.R
\name{csorensendice}
\alias{csorensendice}
\title{Calculate the Sorensen-Dice distance for each species.}
\usage{
csorensendice(
  dataset,
  formula,
  plot = TRUE,
  plot_title = "Sorensen-Dice Distance Between Groups"
)
}
\arguments{
\item{dataset}{A dataframe.}

\item{formula}{A factor which you want to calculate the Sorensen-Dice distances matrix.}

\item{plot}{Logical, if TRUE, a plot of Sorensen-Dice distances matrix is displayed.}

\item{plot_title}{The title to be used for the plot if plot is TRUE.}
}
\value{
A matrix containing Sorensen-Dice distances between each pair of groups and the plot.
}
\description{
This function takes a dataframe and a factor in input, and returns a matrix with the Sorensen-Dice distances about it.
}
\examples{
# Example with the iris dataset

csorensendice(iris, ~Species, plot = TRUE, plot_title = "Sorensen-Dice Distance Between Groups")

# Example with the mtcars dataset
csorensendice(mtcars, ~am, plot = TRUE, plot_title = "Sorensen-Dice Distance Between Groups")

}
