% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.conceptMap.R
\name{summary.conceptMap}
\alias{summary.conceptMap}
\title{Summary of a Concept Map Object}
\usage{
\method{summary}{conceptMap}(object, ...)
}
\arguments{
\item{object}{An object of class \code{"conceptMap"} containing the results of concept mapping analysis
creating using the function \code{"conceptMapping"}.}

\item{...}{arguments to be passed to methods}
}
\value{
This function does not return a value; it prints a summary of the concept map object to the console.
}
\description{
This function provides a summary of a concept map object, including the number of statements,
sorters, clusters, and the distribution of statements across clusters.
}
\details{
The function verifies that the input object is of class \code{"conceptMap"} and extracts key information from it.
It summarizes the number of statements, sorters, and clusters, and details the distribution of statements across
the identified clusters.
}
\examples{
# Simulate data with custom parameters:
set.seed(1)
myCMData <- simulateCardData(nSorters=40, pCorrect=.90, attributeWeights=c(1,1,1,1))

# Subject the data to sorter cluster analysis
myCMDataBySorters <- sorterMapping(myCMData)

# Subject sorter cluster 3 to concept mapping using default "network" method
myCMAnalysis3 <- conceptMapping(myCMDataBySorters[[3]])

# Generate summary of concept map of sorter cluster 3
summary(myCMAnalysis3)

}
