% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluate.R
\name{clustra_sil}
\alias{clustra_sil}
\title{clustra_sil:
Performs \code{\link{clustra}} runs for several k and makes silhouette plots.
Computes a proxy silhouette index based on distances to cluster
centers rather than trajectory pairs. The cost is essentially that of
running clustra for several k as this information is
available directly from clustra.}
\usage{
clustra_sil(
  data,
  k,
  mccores,
  maxdf = 30,
  iter = 10,
  save = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{data}{The data (see \code{\link{clustra}} description).}

\item{k}{Vector of k values to try.}

\item{mccores}{See \code{\link{trajectories}}.}

\item{maxdf}{Fitting parameters. See \code{\link{trajectories}}.}

\item{iter}{Fitting parameters. See \code{\link{trajectories}}.}

\item{save}{Logical. When TRUE, save all results as file \code{clustra_sil.Rdata}.}

\item{verbose}{Logical. When TRUE, information about each run of clustra is printed.}
}
\value{
Invisibly returns a list of length \code{length(k)}, where each element is
a matrix with \code{nrow(data)} rows and three columns \code{cluster}, \code{neighbor},
\code{silhouette}. This list of matrices can be used to draw a silhouette plot.
}
\description{
clustra_sil:
Performs \code{\link{clustra}} runs for several k and makes silhouette plots.
Computes a proxy silhouette index based on distances to cluster
centers rather than trajectory pairs. The cost is essentially that of
running clustra for several k as this information is
available directly from clustra.
}
