% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clusternor.R
\name{Kmeans}
\alias{Kmeans}
\title{Perform k-means clustering on a data matrix.}
\usage{
Kmeans(data, centers, nrow = -1, ncol = -1,
  iter.max = .Machine$integer.max, nthread = -1, init = c("kmeanspp",
  "random", "forgy", "none"), tolerance = 1e-06, dist.type = c("eucl",
  "sqeucl", "cos", "taxi"))
}
\arguments{
\item{data}{Data file name on disk (NUMA optimized) or In memory data matrix}

\item{centers}{Either (i) The number of centers (i.e., k), or}

\item{nrow}{The number of samples in the dataset}

\item{ncol}{The number of features in the dataset}

\item{iter.max}{The maximum number of iteration of k-means to perform}

\item{nthread}{The number of parallel threads to run
(ii) an In-memory data matrix, or (iii) A 2-Element \emph{list} with element 1
being a filename for precomputed centers, and element 2
the number of centroids.}

\item{init}{The type of initialization to use c("kmeanspp", "random",
"forgy", "none")}

\item{tolerance}{The convergence tolerance}

\item{dist.type}{What dissimilarity metric to use}
}
\value{
A list containing the attributes of the output of kmeans.
 cluster: A vector of integers (from 1:\strong{k}) indicating the cluster to
         which each point is allocated.
 centers: A matrix of cluster centres.
 size: The number of points in each cluster.
 iter: The number of (outer) iterations.
}
\description{
K-means provides \strong{k} disjoint sets for a dataset using a parallel and fast
NUMA optimized version of Lloyd's algorithm. The details of which are found
in this paper https://arxiv.org/pdf/1606.08905.pdf.
}
\examples{
iris.mat <- as.matrix(iris[,1:4])
k <- length(unique(iris[, dim(iris)[2]])) # Number of unique classes
kms <- Kmeans(iris.mat, k)

}
\author{
Disa Mhembere <disa@cs.jhu.edu>
}
