% Generated by roxygen2 (4.0.0): do not edit by hand
\name{clusterfly}
\alias{clusterfly}
\alias{package-clusterfly}
\title{Creates a convenient data structure for dealing with a dataset and a number
of alternative clusterings.}
\usage{
clusterfly(df, extra = NULL, rescale = TRUE)
}
\arguments{
\item{df}{data frame to be clustered}

\item{extra}{extra variables to be included in output, but not clustered}

\item{rescale}{rescale, if true each variable will be scaled to have mean 0
and variance 1.}
}
\description{
Once you have created a clusterfly object, you can add
clusterings to it with \code{\link{cfly_cluster}}, and
visualise then in GGobi with \code{\link{cfly_show}} and
\code{\link{cfly_animate}}. Static graphics are also
available: \code{\link{cfly_pcp}} will produce a parallel
coordinates plot, \code{\link{cfly_dist}} will show
the distribution of each variable in each cluster, and
\code{\link{cfly_fluct}} compares two clusterings with a
fluctuation diagram.
}
\details{
If you want to standardise the cluster labelling to one
group, look at \code{\link{clarify}} and \code{\link{cfly_clarify}}
}
\examples{
ol <- olive_example()

if (interactive()) {
ggobi(ol)
cfly_show(ol, "k4-1")
cfly_animate(ol, max = 5)
close(ol)
}
}
\seealso{
vignette("introduction")
}
\keyword{dynamic}

