% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/clusterIM.R
\name{cluster.im}
\alias{cluster.im}
\title{Cluster-Adjusted Standard Errors and p-Values for GLM}
\usage{
cluster.im(mod, dat, cluster, report = TRUE, se = FALSE, drop = FALSE)
}
\arguments{
\item{mod}{A model estimated using \code{glm}.}

\item{dat}{The data set used to estimate \code{mod}.}

\item{cluster}{A formula of the clustering variable.}

\item{report}{Should a table of results be printed to the console?}

\item{se}{Should standard errors be returned?}

\item{drop}{Should clusters within which a model cannot be estimated be dropped?}
}
\value{
A list with the elements
\item{p.values}{A matrix of the estimated p-values.}
\item{se}{The estimated standard errors (if requested).}
}
\description{
Computes p-values and standard errors for GLM models based on cluster-specific model estimation (Ibragimov and Muller 2010). A separate model is estimated in each cluster, and then p-values are computed based on a t/normal distribution of the cluster-specific estimates.
}
\examples{
\dontrun{
# predict whether respondent has a university degree
require(effects)
data(WVS)
logit.model <- glm(degree ~ religion + gender + age, data=WVS, family=binomial(link="logit"))
summary(logit.model)

# compute cluster-adjusted p-values
clust.p <- cluster.im(logit.model, WVS, ~ country, report = T, se = TRUE, drop = FALSE)

# compute 95\% confidence intervals
ci.lo <- coefficients(logit.model) - qt(0.975, df=3)*clust.p$se
ci.hi <- coefficients(logit.model) + qt(0.975, df=3)*clust.p$se
ci <- cbind(ci.lo, ci.hi)
colnames(ci) <- c("95\% lower bound", "95\% upper bound")
ci
}
}
\author{
Justin Esarey
}
\references{
Ibragimov, Rustam, and Ulrich K. Muller. 2010. "t-Statistic Based Correlation and Heterogeneity Robust Inference." \emph{Journal of Business & Economic Statistics} 28(4): 453-468.
}

