% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cps.did.binary.R
\name{cps.did.binary}
\alias{cps.did.binary}
\title{Power simulations for cluster-randomized trials: Difference in Difference, Binary Outcome.}
\usage{
cps.did.binary(
  nsim = NULL,
  nsubjects = NULL,
  nclusters = NULL,
  p.diff = NULL,
  p1t0 = 0,
  p2t0 = NULL,
  p1t1 = NULL,
  p2t1 = NULL,
  or1 = NULL,
  or2 = NULL,
  or.diff = NULL,
  sigma_b_sq0 = NULL,
  sigma_b_sq1 = NULL,
  alpha = 0.05,
  method = "glmm",
  quiet = TRUE,
  allSimData = FALSE,
  poorFitOverride = FALSE,
  lowPowerOverride = FALSE,
  timelimitOverride = TRUE,
  seed = NA,
  nofit = FALSE
)
}
\arguments{
\item{nsim}{Number of datasets to simulate; accepts integer (required).}

\item{nsubjects}{Number of subjects per cluster; accepts integer (required).}

\item{nclusters}{Number of clusters per arm; accepts integer (required).}

\item{p.diff}{Optional if p1t1 and p2t0 are provided. Expected difference 
in outcome proportion between groups, defined as 
p.diff = (p1t1 - p1t0) - (p2t1 - p2t0).


At least 2 of the following 3 arguments must be specified when using 
expected odds ratios:}

\item{p1t0}{Required. Expected outcome proportion in arm 1 at baseline.
Default is 0.}

\item{p2t0}{Optional. Expected outcome proportion in arm 2 at baseline. If 
no quantity is provided, p2t0 = p1t0 is assumed.}

\item{p1t1}{Optional. Expected outcome proportion in arm 1 at follow-up. 
If no quantity is provided, p1t1 = p1t0 is assumed.}

\item{p2t1}{Required. Expected outcome proportion in arm 2 at follow-up.}

\item{or1}{Expected odds ratio for outcome in arm 1}

\item{or2}{Expected odds ratio for outcome in arm 2}

\item{or.diff}{Expected difference in odds ratio for outcome between groups, 
defined as or.diff = or1 - or2.}

\item{sigma_b_sq0}{Pre-treatment (time == 0) between-cluster variance; 
accepts numeric scalar (indicating equal between-cluster variances for 
both arms) or a vector of length 2 specifying treatment-specific 
between-cluster variances.}

\item{sigma_b_sq1}{Post-treatment (time == 1) between-cluster variance; 
accepts numeric scalar (indicating equal between-cluster variances for 
both arms) or a vector of length 2 specifying treatment-specific 
between-cluster variances. If not provided by the user, 
sigma_b_sq1 = sigma_b_sq0.}

\item{alpha}{Significance level. Default = 0.05}

\item{method}{Analytical method, either Generalized Linear Mixed 
Effects Model (GLMM) or Generalized Estimating Equation (GEE). 
Accepts c('glmm', 'gee') (required); default = 'glmm'.}

\item{quiet}{When set to FALSE, displays simulation start time and 
completion time. Default is TRUE.}

\item{allSimData}{Option to output list of all simulated datasets. 
Default = FALSE.}

\item{poorFitOverride}{Option to override \code{stop()} if more than 25\%
of fits fail to converge; default = FALSE.}

\item{lowPowerOverride}{Option to override \code{stop()} if the power
is less than 0.5 after the first 50 simulations and every ten simulations
thereafter. On function execution stop, the actual power is printed in the
stop message. Default = FALSE. When TRUE, this check is ignored and the
calculated power is returned regardless of value.}

\item{timelimitOverride}{Logical. When FALSE, stops execution if the 
estimated completion time is more than 2 minutes. Defaults to TRUE.}

\item{seed}{Option to set the seed. Default is NA.}

\item{nofit}{Option to skip model fitting and analysis and only return 
the simulated data. Default = \code{FALSE}.}
}
\value{
A list with the following components
\itemize{
  \item Character string indicating total number of simulations, simulation type, 
  and number of convergent models
  \item Number of simulations
  \item Data frame with columns "Power" (Estimated statistical power), 
               "lower.95.ci" (Lower 95% confidence interval bound), 
               "upper.95.ci" (Upper 95% confidence interval bound)
  \item Analytic method used for power estimation
  \item Significance level
  \item Vector containing user-defined cluster sizes
  \item Vector containing user-defined number of clusters
  \item Data frame reporting sigma_b_sq for each group at each time point
  \item Vector containing expected difference in probabilities based on user inputs
  \item Data frame with columns: 
                  "Period" (Pre/Post-treatment indicator), 
                  "Arm" (Arm indicator), 
                  "Value" (Mean response value)
  \item Data frame containing three estimates of ICC
  \item Data frame with columns: 
                  "Estimate" (Estimate of treatment effect for a given simulation), 
                  "Std.err" (Standard error for treatment effect estimate), 
                  "Test.statistic" (z-value (for GLMM) or Wald statistic (for GEE)), 
                  "p.value", 
                  "converge" (Did simulated model converge?), 
                  "sig.val" (Is p-value less than alpha?)
  \item If \code{allSimData = TRUE}, a list of data frames, each containing: 
                  "y" (Simulated response value), 
                  "trt" (Indicator for arm), 
                  "clust" (Indicator for cluster), 
                  "period" (Indicator for time point)
  \item List of warning messages produced by non-convergent models. 
                      Includes model number for cross-referencing against 
                      \code{model.estimates}
}
If \code{nofit = T}, a data frame of the simulated data sets, containing:
\itemize{
  \item "arm" (Indicator for treatment arm)
  \item "cluster" (Indicator for cluster)
  \item "y1" ... "yn" (Simulated response value for each of the \code{nsim} data sets).
  }
}
\description{
\loadmathjax

This function utilizes iterative simulations to determine 
approximate power for cluster-randomized controlled trials. Users 
can modify a variety of parameters to suit the simulations to their
desired experimental situation.

Runs the power simulation for difference in difference RCTs with binary outcomes.

Users must specify the desired number of simulations, number of subjects per 
cluster, number of clusters per arm, pre-treatment between-cluster variance, 
and two of the following three terms: 
expected probability of outcome in arm 1, expected probability of 
outcome in arm 2, expected difference in probabilities between groups
; post-treatment between-cluster variance, significance level, analytic method, progress updates, 
and simulated data set output may also be specified.

The following equations are used to estimate intra-cluster correlation coefficients:

P_h: \mjsdeqn{ICC = \frac{\sigma_{b}}{\sigma_{b} + \pi^{2}/3}}
P_c: \mjsdeqn{ICC = \frac{P(Y_{ij} = 1, Y_{ih} = 1) - \pi_{j}\pi_{h}}{\sqrt{\pi_{j}(1 - \pi_{j})\pi_{h}(1 - \pi_{h})}}}
P_lmer: \mjsdeqn{ICC = \frac{\sigma_{b}}{\sigma_{b} + \sigma_{w}}}
}
\examples{

# Estimate power for a trial with 10 clusters in both arms, those clusters having
# 20 subjects each, with sigma_b_sq0 = 1. We have estimated arm proportions of 0.2
# and 0.3 in the first and second arms, respectively, and we use
# 100 simulated data sets analyzed by the GLMM method. The resulting estimated power 
# (if you set seed = 123) should be about 0.78.

\dontrun{
did.binary.sim = cps.did.binary(nsim = 100, nsubjects = 20, nclusters = 10, 
                                p1t0 = 0.1, p2t0 = 0.1,  
                                p1t1 = 0.2, p2t1 = 0.45, sigma_b_sq0 = 1, 
                                sigma_b_sq1 = 1, alpha = 0.05,
                                method = 'glmm', allSimData = FALSE, seed = 123)
}

}
\references{
Snjiders, T. & Bosker, R. Multilevel Analysis: an Introduction to Basic and 
Advanced Multilevel Modelling. London, 1999: Sage.

Elridge, S., Ukoumunne, O. & Carlin, J. The Intra-Cluster Correlation 
Coefficient in Cluster Randomized Trials: A Review of Definitions. International 
Statistical Review (2009), 77, 3, 378-394. doi: 10.1111/j.1751-5823.2009.00092.x
}
\author{
Alexander R. Bogdan

Alexandria C. Sakrejda (\email{acbro0@umass.edu}

Ken Kleinman (\email{ken.kleinman@gmail.com})
}
