% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logfactSum.R
\name{logfactSum}
\alias{logfactSum}
\title{logfactSum}
\usage{
logfactSum(x, Nglobal = getOption("clrng.Nglobal"))
}
\arguments{
\item{x}{a matrix of integers.}

\item{Nglobal}{a (non-empty) integer vector specifying size of the index space for use.}
}
\value{
sum of log-factorials of elements of the input matrix `x'.
}
\description{
Computes the log-factorial of a table on a GPU.
}
\examples{

library(clrng)
if (detectGPUs() >= 1) {
setContext(grep("gpu", listContexts()$device_type)[1])

x <- matrix(c(1:36), 6,6)
logfactSum(x, c(2,2))
# note if matrix is not of integers, a warning will be displayed, eg.
x2 <- matrix(c(1.1,2.1,3.1,4.1,5.1,6.1,7.1,8.1,9.1), 3,3)
is.integer(x2)
logfactSum(x2, c(16,16))} else {
  message("No GPU context available")
}

}
