% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drive_transfer_bulk.R
\name{cloud_drive_read_bulk}
\alias{cloud_drive_read_bulk}
\title{Bulk Read Contents from Google Drive}
\usage{
cloud_drive_read_bulk(content, fun = NULL, ..., quiet = FALSE)
}
\arguments{
\item{content}{(data.frame) Output of \code{cloud_drive_ls()}}

\item{fun}{A custom reading function. If \code{NULL} (default), the appropriate
reading function will be inferred based on the file's extension.}

\item{...}{Additional arguments to pass to the reading function \code{fun}.}

\item{quiet}{All caution messages may be turned off by setting this parameter
to \code{TRUE}.}
}
\value{
A named list where each element corresponds to the content of a file
from Google Drive. The names of the list elements are derived from the file
names.
}
\description{
This function facilitates the bulk reading of multiple files
from the project's designated Google Drive folder. By using
\link{cloud_drive_ls}, you can obtain a dataframe detailing the contents of the
Google Drive folder. Applying \code{cloud_drive_read_bulk} to this dataframe
allows you to read all listed files into a named list. The function will,
by default, infer the appropriate reading method based on each file's
extension. However, if a specific reading function is provided via the
\code{fun} parameter, it will be applied uniformly to all files, which may not
be suitable for diverse file types.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# provided there's a folder called "data" in the root of the project's main
# Google Drive folder, and it contains csv files
data_lst <- 
  cloud_drive_ls("data") |> 
  filter(type == "csv") |> 
  cloud_drive_read_bulk()
  
\dontshow{\}) # examplesIf}
}
