% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cli.R
\name{cli_yeah}
\alias{cli_yeah}
\title{User Interface: Ask a Yes/No question}
\usage{
cli_yeah(x, straight = FALSE, .envir = parent.frame())
}
\arguments{
\item{x}{Question to display.}

\item{straight}{(logical) Ask a straight Yes/No question? By default (when
\code{FALSE}), two different "no" options and one "yes" option are sampled from
a pool of variants. In other words it behaves just like \code{usethis::ui_yeah}
with default parameter setup. When \code{straight = TRUE}, it only shows "Yes"
and "No", literally.}

\item{.envir}{Environment to evaluate the glue expressions in.}
}
\value{
(logical) Returns \code{TRUE} when the user selects a "yes" option and
\code{FALSE} otherwise, i.e. when user selects a "no" option or refuses to make
a selection (cancels).
}
\description{
This function is inspired by (if not mostly copied from)
\code{usethis::ui_yeah} function. It's purpose is to ask user a yes/no question.
The differences are:
\enumerate{
\item It is more limited in answer options customization. This is done on
purpose to standardize command line dialogues in our code.
\item It uses \code{cli} package under the hood, so \code{cli} rich text formatting is
possible.
}
}
\keyword{internal}
