/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.ipnreturnurlvalidation;

import com.amazonaws.ipnreturnurlvalidation.URLReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.util.Map;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SignatureUtilsForOutbound {
    public static final String SIGNATURE_KEYNAME = "signature";
    public static final String SIGNATURE_METHOD_KEYNAME = "signatureMethod";
    public static final String SIGNATURE_VERSION_KEYNAME = "signatureVersion";
    public static final String SIGNATURE_VERSION_2 = "2";
    public static final String RSA_SHA1_ALGORITHM = "SHA1withRSA";
    public static final String CERTIFICATE_URL_KEYNAME = "certificateUrl";
    private static final String EMPTY_STRING = "";
    private static final String UTF_8_Encoding = "UTF-8";
    private static final String FPS_PROD_ENDPOINT = "https://fps.amazonaws.com/";
    private static final String FPS_SANDBOX_ENDPOINT = "https://fps.sandbox.amazonaws.com/";
    private static final String ACTION_PARAM = "?Action=VerifySignature";
    private static final String END_POINT_PARAM = "&UrlEndPoint=";
    private static final String HTTP_PARAMS_PARAM = "&HttpParameters=";
    private static final String VERSION_PARAM_VALUE = "&Version=2010-08-28";
    private static final String SUCCESS_RESPONSE = "<VerificationStatus>Success</VerificationStatus>";
    protected static final String USER_AGENT_STRING = "amazon-fps-2010-08-28-java-library";
    private String awsAccessKey;
    private String awsSecretKey;

    public SignatureUtilsForOutbound() {
    }

    public SignatureUtilsForOutbound(String awsAccessKey, String awsSecretKey) {
        this.awsAccessKey = awsAccessKey;
        this.awsSecretKey = awsSecretKey;
    }

    public boolean validateRequest(Map<String, String> parameters, String urlEndPoint, String httpMethod) throws SignatureException {
        String signatureVersion = parameters.get(SIGNATURE_VERSION_KEYNAME);
        if (SIGNATURE_VERSION_2.equals(signatureVersion)) {
            return this.validateSignatureV2(parameters, urlEndPoint, httpMethod);
        }
        return this.validateSignatureV1(parameters);
    }

    private boolean validateSignatureV1(Map<String, String> parameters) throws SignatureException {
        String result;
        if (this.awsSecretKey == null) {
            throw new SignatureException("Signature can not be verified without aws secret key.");
        }
        String stringToSign = this.calculateStringToSignV1(parameters);
        String signature = null;
        if (!parameters.containsKey(SIGNATURE_KEYNAME)) {
            throw new SignatureException("Signature is not present in input parameters.");
        }
        signature = parameters.get(SIGNATURE_KEYNAME);
        try {
            SecretKeySpec signingKey = new SecretKeySpec(this.awsSecretKey.getBytes(), "HmacSHA1");
            Mac mac = Mac.getInstance("HmacSHA1");
            mac.init(signingKey);
            byte[] rawHmac = mac.doFinal(stringToSign.getBytes(UTF_8_Encoding));
            result = new String(Base64.encodeBase64((byte[])rawHmac));
        }
        catch (NoSuchAlgorithmException e) {
            throw new SignatureException("Failed to generate HMAC : " + e.getMessage());
        }
        catch (InvalidKeyException e) {
            throw new SignatureException("Failed to generate HMAC : " + e.getMessage());
        }
        catch (UnsupportedEncodingException e) {
            throw new SignatureException("Failed to generate HMAC : " + e.getMessage());
        }
        return result.equals(signature);
    }

    private boolean validateSignatureV2(Map<String, String> parameters, String urlEndPoint, String httpMethod) throws SignatureException {
        if (parameters == null || parameters.size() == 0) {
            throw new SignatureException("must provide http parameters");
        }
        String signature = parameters.get(SIGNATURE_KEYNAME);
        if (signature == null || EMPTY_STRING.equals(signature)) {
            throw new SignatureException("signature is missing from the parameters.");
        }
        String signatureVersion = parameters.get(SIGNATURE_VERSION_KEYNAME);
        if (signatureVersion == null || EMPTY_STRING.equals(signatureVersion)) {
            throw new SignatureException("signatureVersion is missing from the parameters.");
        }
        String signatureMethod = parameters.get(SIGNATURE_METHOD_KEYNAME);
        if (signatureMethod == null || EMPTY_STRING.equals(signatureMethod)) {
            throw new SignatureException("signatureMethod is missing from the parameters.");
        }
        String certificateUrl = parameters.get(CERTIFICATE_URL_KEYNAME);
        if (certificateUrl == null || EMPTY_STRING.equals(certificateUrl)) {
            throw new SignatureException("certificateUrl is missing from the parameters.");
        }
        if (urlEndPoint == null || EMPTY_STRING.equals(urlEndPoint)) {
            throw new SignatureException("urlEndPoint must be specified");
        }
        StringBuilder requestUrlBuilder = new StringBuilder();
        if (certificateUrl.startsWith(FPS_PROD_ENDPOINT)) {
            requestUrlBuilder.append(FPS_PROD_ENDPOINT);
        } else if (certificateUrl.startsWith(FPS_SANDBOX_ENDPOINT)) {
            requestUrlBuilder.append(FPS_SANDBOX_ENDPOINT);
        } else {
            throw new SignatureException("certificate url was incorrect");
        }
        requestUrlBuilder.append(ACTION_PARAM);
        requestUrlBuilder.append(END_POINT_PARAM);
        requestUrlBuilder.append(urlEndPoint);
        requestUrlBuilder.append(HTTP_PARAMS_PARAM);
        requestUrlBuilder.append(this.buildHttpParams(parameters));
        requestUrlBuilder.append(VERSION_PARAM_VALUE);
        String requestUrl = requestUrlBuilder.toString();
        String verifySignatureResponse = null;
        try {
            verifySignatureResponse = URLReader.getUrlContents(requestUrl);
        }
        catch (IOException e) {
            throw new SignatureException("call to VerifySignature API failed", e);
        }
        return verifySignatureResponse.contains(SUCCESS_RESPONSE);
    }

    private String buildHttpParams(Map<String, String> httpParams) {
        StringBuilder paramsBuilder = new StringBuilder();
        boolean first = true;
        for (String key : httpParams.keySet()) {
            if (!first) {
                paramsBuilder.append("&");
            } else {
                first = false;
            }
            paramsBuilder.append(this.urlEncode(key));
            paramsBuilder.append("=");
            paramsBuilder.append(this.urlEncode(httpParams.get(key)));
        }
        return this.urlEncode(paramsBuilder.toString());
    }

    private String urlEncode(String value) {
        String encoded = null;
        try {
            encoded = URLEncoder.encode(value, UTF_8_Encoding);
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        return encoded;
    }

    private String calculateStringToSignV1(Map<String, String> parameters) {
        StringBuilder data = new StringBuilder();
        TreeMap<String, String> sorted = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        sorted.putAll(parameters);
        for (Map.Entry entry : sorted.entrySet()) {
            if (((String)entry.getKey()).equalsIgnoreCase(SIGNATURE_KEYNAME)) continue;
            data.append((String)entry.getKey());
            data.append((String)entry.getValue());
        }
        return data.toString();
    }
}

