/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticache.model;

import com.amazonaws.AmazonWebServiceRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModifyCacheClusterRequest
extends AmazonWebServiceRequest {
    private String cacheClusterId;
    private Integer numCacheNodes;
    private List<String> cacheNodeIdsToRemove;
    private List<String> cacheSecurityGroupNames;
    private String preferredMaintenanceWindow;
    private String notificationTopicArn;
    private String cacheParameterGroupName;
    private String notificationTopicStatus;
    private Boolean applyImmediately;
    private String engineVersion;
    private Boolean autoMinorVersionUpgrade;

    public ModifyCacheClusterRequest() {
    }

    public ModifyCacheClusterRequest(String cacheClusterId) {
        this.cacheClusterId = cacheClusterId;
    }

    public String getCacheClusterId() {
        return this.cacheClusterId;
    }

    public void setCacheClusterId(String cacheClusterId) {
        this.cacheClusterId = cacheClusterId;
    }

    public ModifyCacheClusterRequest withCacheClusterId(String cacheClusterId) {
        this.cacheClusterId = cacheClusterId;
        return this;
    }

    public Integer getNumCacheNodes() {
        return this.numCacheNodes;
    }

    public void setNumCacheNodes(Integer numCacheNodes) {
        this.numCacheNodes = numCacheNodes;
    }

    public ModifyCacheClusterRequest withNumCacheNodes(Integer numCacheNodes) {
        this.numCacheNodes = numCacheNodes;
        return this;
    }

    public List<String> getCacheNodeIdsToRemove() {
        if (this.cacheNodeIdsToRemove == null) {
            this.cacheNodeIdsToRemove = new ArrayList<String>();
        }
        return this.cacheNodeIdsToRemove;
    }

    public void setCacheNodeIdsToRemove(Collection<String> cacheNodeIdsToRemove) {
        if (cacheNodeIdsToRemove == null) {
            this.cacheNodeIdsToRemove = null;
            return;
        }
        ArrayList<String> cacheNodeIdsToRemoveCopy = new ArrayList<String>(cacheNodeIdsToRemove.size());
        cacheNodeIdsToRemoveCopy.addAll(cacheNodeIdsToRemove);
        this.cacheNodeIdsToRemove = cacheNodeIdsToRemoveCopy;
    }

    public ModifyCacheClusterRequest withCacheNodeIdsToRemove(String ... cacheNodeIdsToRemove) {
        if (this.getCacheNodeIdsToRemove() == null) {
            this.setCacheNodeIdsToRemove(new ArrayList<String>(cacheNodeIdsToRemove.length));
        }
        for (String value : cacheNodeIdsToRemove) {
            this.getCacheNodeIdsToRemove().add(value);
        }
        return this;
    }

    public ModifyCacheClusterRequest withCacheNodeIdsToRemove(Collection<String> cacheNodeIdsToRemove) {
        if (cacheNodeIdsToRemove == null) {
            this.cacheNodeIdsToRemove = null;
        } else {
            ArrayList<String> cacheNodeIdsToRemoveCopy = new ArrayList<String>(cacheNodeIdsToRemove.size());
            cacheNodeIdsToRemoveCopy.addAll(cacheNodeIdsToRemove);
            this.cacheNodeIdsToRemove = cacheNodeIdsToRemoveCopy;
        }
        return this;
    }

    public List<String> getCacheSecurityGroupNames() {
        if (this.cacheSecurityGroupNames == null) {
            this.cacheSecurityGroupNames = new ArrayList<String>();
        }
        return this.cacheSecurityGroupNames;
    }

    public void setCacheSecurityGroupNames(Collection<String> cacheSecurityGroupNames) {
        if (cacheSecurityGroupNames == null) {
            this.cacheSecurityGroupNames = null;
            return;
        }
        ArrayList<String> cacheSecurityGroupNamesCopy = new ArrayList<String>(cacheSecurityGroupNames.size());
        cacheSecurityGroupNamesCopy.addAll(cacheSecurityGroupNames);
        this.cacheSecurityGroupNames = cacheSecurityGroupNamesCopy;
    }

    public ModifyCacheClusterRequest withCacheSecurityGroupNames(String ... cacheSecurityGroupNames) {
        if (this.getCacheSecurityGroupNames() == null) {
            this.setCacheSecurityGroupNames(new ArrayList<String>(cacheSecurityGroupNames.length));
        }
        for (String value : cacheSecurityGroupNames) {
            this.getCacheSecurityGroupNames().add(value);
        }
        return this;
    }

    public ModifyCacheClusterRequest withCacheSecurityGroupNames(Collection<String> cacheSecurityGroupNames) {
        if (cacheSecurityGroupNames == null) {
            this.cacheSecurityGroupNames = null;
        } else {
            ArrayList<String> cacheSecurityGroupNamesCopy = new ArrayList<String>(cacheSecurityGroupNames.size());
            cacheSecurityGroupNamesCopy.addAll(cacheSecurityGroupNames);
            this.cacheSecurityGroupNames = cacheSecurityGroupNamesCopy;
        }
        return this;
    }

    public String getPreferredMaintenanceWindow() {
        return this.preferredMaintenanceWindow;
    }

    public void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
        this.preferredMaintenanceWindow = preferredMaintenanceWindow;
    }

    public ModifyCacheClusterRequest withPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
        this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        return this;
    }

    public String getNotificationTopicArn() {
        return this.notificationTopicArn;
    }

    public void setNotificationTopicArn(String notificationTopicArn) {
        this.notificationTopicArn = notificationTopicArn;
    }

    public ModifyCacheClusterRequest withNotificationTopicArn(String notificationTopicArn) {
        this.notificationTopicArn = notificationTopicArn;
        return this;
    }

    public String getCacheParameterGroupName() {
        return this.cacheParameterGroupName;
    }

    public void setCacheParameterGroupName(String cacheParameterGroupName) {
        this.cacheParameterGroupName = cacheParameterGroupName;
    }

    public ModifyCacheClusterRequest withCacheParameterGroupName(String cacheParameterGroupName) {
        this.cacheParameterGroupName = cacheParameterGroupName;
        return this;
    }

    public String getNotificationTopicStatus() {
        return this.notificationTopicStatus;
    }

    public void setNotificationTopicStatus(String notificationTopicStatus) {
        this.notificationTopicStatus = notificationTopicStatus;
    }

    public ModifyCacheClusterRequest withNotificationTopicStatus(String notificationTopicStatus) {
        this.notificationTopicStatus = notificationTopicStatus;
        return this;
    }

    public Boolean isApplyImmediately() {
        return this.applyImmediately;
    }

    public void setApplyImmediately(Boolean applyImmediately) {
        this.applyImmediately = applyImmediately;
    }

    public ModifyCacheClusterRequest withApplyImmediately(Boolean applyImmediately) {
        this.applyImmediately = applyImmediately;
        return this;
    }

    public Boolean getApplyImmediately() {
        return this.applyImmediately;
    }

    public String getEngineVersion() {
        return this.engineVersion;
    }

    public void setEngineVersion(String engineVersion) {
        this.engineVersion = engineVersion;
    }

    public ModifyCacheClusterRequest withEngineVersion(String engineVersion) {
        this.engineVersion = engineVersion;
        return this;
    }

    public Boolean isAutoMinorVersionUpgrade() {
        return this.autoMinorVersionUpgrade;
    }

    public void setAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
        this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
    }

    public ModifyCacheClusterRequest withAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
        this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
        return this;
    }

    public Boolean getAutoMinorVersionUpgrade() {
        return this.autoMinorVersionUpgrade;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.cacheClusterId != null) {
            sb.append("CacheClusterId: " + this.cacheClusterId + ", ");
        }
        if (this.numCacheNodes != null) {
            sb.append("NumCacheNodes: " + this.numCacheNodes + ", ");
        }
        if (this.cacheNodeIdsToRemove != null) {
            sb.append("CacheNodeIdsToRemove: " + this.cacheNodeIdsToRemove + ", ");
        }
        if (this.cacheSecurityGroupNames != null) {
            sb.append("CacheSecurityGroupNames: " + this.cacheSecurityGroupNames + ", ");
        }
        if (this.preferredMaintenanceWindow != null) {
            sb.append("PreferredMaintenanceWindow: " + this.preferredMaintenanceWindow + ", ");
        }
        if (this.notificationTopicArn != null) {
            sb.append("NotificationTopicArn: " + this.notificationTopicArn + ", ");
        }
        if (this.cacheParameterGroupName != null) {
            sb.append("CacheParameterGroupName: " + this.cacheParameterGroupName + ", ");
        }
        if (this.notificationTopicStatus != null) {
            sb.append("NotificationTopicStatus: " + this.notificationTopicStatus + ", ");
        }
        if (this.applyImmediately != null) {
            sb.append("ApplyImmediately: " + this.applyImmediately + ", ");
        }
        if (this.engineVersion != null) {
            sb.append("EngineVersion: " + this.engineVersion + ", ");
        }
        if (this.autoMinorVersionUpgrade != null) {
            sb.append("AutoMinorVersionUpgrade: " + this.autoMinorVersionUpgrade + ", ");
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCacheClusterId() == null ? 0 : this.getCacheClusterId().hashCode());
        hashCode = 31 * hashCode + (this.getNumCacheNodes() == null ? 0 : this.getNumCacheNodes().hashCode());
        hashCode = 31 * hashCode + (this.getCacheNodeIdsToRemove() == null ? 0 : ((Object)this.getCacheNodeIdsToRemove()).hashCode());
        hashCode = 31 * hashCode + (this.getCacheSecurityGroupNames() == null ? 0 : ((Object)this.getCacheSecurityGroupNames()).hashCode());
        hashCode = 31 * hashCode + (this.getPreferredMaintenanceWindow() == null ? 0 : this.getPreferredMaintenanceWindow().hashCode());
        hashCode = 31 * hashCode + (this.getNotificationTopicArn() == null ? 0 : this.getNotificationTopicArn().hashCode());
        hashCode = 31 * hashCode + (this.getCacheParameterGroupName() == null ? 0 : this.getCacheParameterGroupName().hashCode());
        hashCode = 31 * hashCode + (this.getNotificationTopicStatus() == null ? 0 : this.getNotificationTopicStatus().hashCode());
        hashCode = 31 * hashCode + (this.isApplyImmediately() == null ? 0 : this.isApplyImmediately().hashCode());
        hashCode = 31 * hashCode + (this.getEngineVersion() == null ? 0 : this.getEngineVersion().hashCode());
        hashCode = 31 * hashCode + (this.isAutoMinorVersionUpgrade() == null ? 0 : this.isAutoMinorVersionUpgrade().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyCacheClusterRequest)) {
            return false;
        }
        ModifyCacheClusterRequest other = (ModifyCacheClusterRequest)obj;
        if (other.getCacheClusterId() == null ^ this.getCacheClusterId() == null) {
            return false;
        }
        if (other.getCacheClusterId() != null && !other.getCacheClusterId().equals(this.getCacheClusterId())) {
            return false;
        }
        if (other.getNumCacheNodes() == null ^ this.getNumCacheNodes() == null) {
            return false;
        }
        if (other.getNumCacheNodes() != null && !other.getNumCacheNodes().equals(this.getNumCacheNodes())) {
            return false;
        }
        if (other.getCacheNodeIdsToRemove() == null ^ this.getCacheNodeIdsToRemove() == null) {
            return false;
        }
        if (other.getCacheNodeIdsToRemove() != null && !((Object)other.getCacheNodeIdsToRemove()).equals(this.getCacheNodeIdsToRemove())) {
            return false;
        }
        if (other.getCacheSecurityGroupNames() == null ^ this.getCacheSecurityGroupNames() == null) {
            return false;
        }
        if (other.getCacheSecurityGroupNames() != null && !((Object)other.getCacheSecurityGroupNames()).equals(this.getCacheSecurityGroupNames())) {
            return false;
        }
        if (other.getPreferredMaintenanceWindow() == null ^ this.getPreferredMaintenanceWindow() == null) {
            return false;
        }
        if (other.getPreferredMaintenanceWindow() != null && !other.getPreferredMaintenanceWindow().equals(this.getPreferredMaintenanceWindow())) {
            return false;
        }
        if (other.getNotificationTopicArn() == null ^ this.getNotificationTopicArn() == null) {
            return false;
        }
        if (other.getNotificationTopicArn() != null && !other.getNotificationTopicArn().equals(this.getNotificationTopicArn())) {
            return false;
        }
        if (other.getCacheParameterGroupName() == null ^ this.getCacheParameterGroupName() == null) {
            return false;
        }
        if (other.getCacheParameterGroupName() != null && !other.getCacheParameterGroupName().equals(this.getCacheParameterGroupName())) {
            return false;
        }
        if (other.getNotificationTopicStatus() == null ^ this.getNotificationTopicStatus() == null) {
            return false;
        }
        if (other.getNotificationTopicStatus() != null && !other.getNotificationTopicStatus().equals(this.getNotificationTopicStatus())) {
            return false;
        }
        if (other.isApplyImmediately() == null ^ this.isApplyImmediately() == null) {
            return false;
        }
        if (other.isApplyImmediately() != null && !other.isApplyImmediately().equals(this.isApplyImmediately())) {
            return false;
        }
        if (other.getEngineVersion() == null ^ this.getEngineVersion() == null) {
            return false;
        }
        if (other.getEngineVersion() != null && !other.getEngineVersion().equals(this.getEngineVersion())) {
            return false;
        }
        if (other.isAutoMinorVersionUpgrade() == null ^ this.isAutoMinorVersionUpgrade() == null) {
            return false;
        }
        return other.isAutoMinorVersionUpgrade() == null || other.isAutoMinorVersionUpgrade().equals(this.isAutoMinorVersionUpgrade());
    }
}

