/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.util;

import com.amazonaws.services.elasticmapreduce.model.HadoopJarStepConfig;
import com.amazonaws.util.StringUtils;
import java.util.ArrayList;

public class StepFactory {
    private final String bucket;

    public StepFactory() {
        this("us-east-1.elasticmapreduce");
    }

    public StepFactory(String bucket) {
        this.bucket = bucket;
    }

    public HadoopJarStepConfig newScriptRunnerStep(String script, String ... args) {
        ArrayList<String> argsList = new ArrayList<String>();
        argsList.add(script);
        for (String arg : args) {
            argsList.add(arg);
        }
        return new HadoopJarStepConfig().withJar("s3://" + this.bucket + "/libs/script-runner/script-runner.jar").withArgs(argsList);
    }

    public HadoopJarStepConfig newEnableDebuggingStep() {
        return this.newScriptRunnerStep("s3://" + this.bucket + "/libs/state-pusher/0.1/fetch", new String[0]);
    }

    public HadoopJarStepConfig newInstallHiveStep(HiveVersion ... hiveVersions) {
        if (hiveVersions.length > 0) {
            String[] versionStrings = new String[hiveVersions.length];
            for (int i = 0; i < hiveVersions.length; ++i) {
                versionStrings[i] = hiveVersions[i].toString();
            }
            return this.newInstallHiveStep(versionStrings);
        }
        return this.newHivePigStep("hive", "--install-hive");
    }

    public HadoopJarStepConfig newInstallHiveStep(String ... hiveVersions) {
        if (hiveVersions.length > 0) {
            return this.newHivePigStep("hive", "--install-hive", "--hive-versions", StringUtils.join(",", hiveVersions));
        }
        return this.newHivePigStep("hive", "--install-hive");
    }

    public HadoopJarStepConfig newInstallHiveStep() {
        return this.newInstallHiveStep(new HiveVersion[0]);
    }

    public HadoopJarStepConfig newRunHiveScriptStep(String script, String ... args) {
        String[] argsArray = new String[args.length + 4];
        argsArray[0] = "--run-hive-script";
        argsArray[1] = "--args";
        argsArray[2] = "-f";
        argsArray[3] = script;
        System.arraycopy(args, 0, argsArray, 4, args.length);
        return this.newHivePigStep("hive", argsArray);
    }

    public HadoopJarStepConfig newInstallPigStep() {
        return this.newHivePigStep("pig", "--install-pig");
    }

    public HadoopJarStepConfig newRunPigScriptStep(String script, String ... args) {
        String[] argsArray = new String[args.length + 4];
        argsArray[0] = "--run-pig-script";
        argsArray[1] = "--args";
        argsArray[2] = "-f";
        argsArray[3] = script;
        System.arraycopy(args, 0, argsArray, 4, args.length);
        return this.newHivePigStep("pig", argsArray);
    }

    private HadoopJarStepConfig newHivePigStep(String type, String ... args) {
        String[] argsArray = new String[args.length + 2];
        argsArray[0] = "--base-path";
        argsArray[1] = "s3://" + this.bucket + "/libs/" + type + "/";
        System.arraycopy(args, 0, argsArray, 2, args.length);
        return this.newScriptRunnerStep("s3://" + this.bucket + "/libs/" + type + "/" + type + "-script", argsArray);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum HiveVersion {
        Hive_0_5("0.5"),
        Hive_0_7("0.7"),
        Hive_0_7_1("0.7.1");

        private String stringVal;

        private HiveVersion(String str) {
            this.stringVal = str;
        }

        public String toString() {
            return this.stringVal;
        }
    }
}

