/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodb.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.dynamodb.model.AttributeValue;
import com.amazonaws.services.dynamodb.model.DeleteItemRequest;
import com.amazonaws.services.dynamodb.model.ExpectedAttributeValue;
import com.amazonaws.services.dynamodb.model.Key;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteItemRequestMarshaller
implements Marshaller<Request<DeleteItemRequest>, DeleteItemRequest> {
    @Override
    public Request<DeleteItemRequest> marshall(DeleteItemRequest deleteItemRequest) {
        if (deleteItemRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DeleteItemRequest> request = new DefaultRequest<DeleteItemRequest>(deleteItemRequest, "AmazonDynamoDB");
        String target = "DynamoDB_20111205.DeleteItem";
        request.addHeader("X-Amz-Target", target);
        request.addHeader("Content-Type", "application/x-amz-json-1.0");
        request.setHttpMethod(HttpMethodName.POST);
        try {
            Key keyKey;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (deleteItemRequest.getTableName() != null) {
                jsonWriter.key("TableName").value(deleteItemRequest.getTableName());
            }
            if (deleteItemRequest != null && (keyKey = deleteItemRequest.getKey()) != null) {
                AttributeValue attributeValueRangeKeyElement;
                int nSListIndex;
                List<String> nSList;
                int sSListIndex;
                List<String> sSList;
                AttributeValue attributeValueHashKeyElement;
                jsonWriter.key("Key").object();
                if (keyKey != null && (attributeValueHashKeyElement = keyKey.getHashKeyElement()) != null) {
                    jsonWriter.key("HashKeyElement").object();
                    if (attributeValueHashKeyElement.getS() != null) {
                        jsonWriter.key("S").value(attributeValueHashKeyElement.getS());
                    }
                    if (attributeValueHashKeyElement.getN() != null) {
                        jsonWriter.key("N").value(attributeValueHashKeyElement.getN());
                    }
                    if (attributeValueHashKeyElement != null) {
                        sSList = attributeValueHashKeyElement.getSS();
                        sSListIndex = 0;
                        if (sSList != null && sSList.size() > 0) {
                            jsonWriter.key("SS").array();
                            for (String sSListValue : sSList) {
                                if (sSListValue != null) {
                                    jsonWriter.value(sSListValue);
                                } else {
                                    jsonWriter.value(null);
                                }
                                ++sSListIndex;
                            }
                            jsonWriter.endArray();
                        }
                    }
                    if (attributeValueHashKeyElement != null) {
                        nSList = attributeValueHashKeyElement.getNS();
                        nSListIndex = 0;
                        if (nSList != null && nSList.size() > 0) {
                            jsonWriter.key("NS").array();
                            for (String nSListValue : nSList) {
                                if (nSListValue != null) {
                                    jsonWriter.value(nSListValue);
                                } else {
                                    jsonWriter.value(null);
                                }
                                ++nSListIndex;
                            }
                            jsonWriter.endArray();
                        }
                    }
                    jsonWriter.endObject();
                }
                if (keyKey != null && (attributeValueRangeKeyElement = keyKey.getRangeKeyElement()) != null) {
                    jsonWriter.key("RangeKeyElement").object();
                    if (attributeValueRangeKeyElement.getS() != null) {
                        jsonWriter.key("S").value(attributeValueRangeKeyElement.getS());
                    }
                    if (attributeValueRangeKeyElement.getN() != null) {
                        jsonWriter.key("N").value(attributeValueRangeKeyElement.getN());
                    }
                    if (attributeValueRangeKeyElement != null) {
                        sSList = attributeValueRangeKeyElement.getSS();
                        sSListIndex = 0;
                        if (sSList != null && sSList.size() > 0) {
                            jsonWriter.key("SS").array();
                            for (String sSListValue : sSList) {
                                if (sSListValue != null) {
                                    jsonWriter.value(sSListValue);
                                } else {
                                    jsonWriter.value(null);
                                }
                                ++sSListIndex;
                            }
                            jsonWriter.endArray();
                        }
                    }
                    if (attributeValueRangeKeyElement != null) {
                        nSList = attributeValueRangeKeyElement.getNS();
                        nSListIndex = 0;
                        if (nSList != null && nSList.size() > 0) {
                            jsonWriter.key("NS").array();
                            for (String nSListValue : nSList) {
                                if (nSListValue != null) {
                                    jsonWriter.value(nSListValue);
                                } else {
                                    jsonWriter.value(null);
                                }
                                ++nSListIndex;
                            }
                            jsonWriter.endArray();
                        }
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endObject();
            }
            if (deleteItemRequest.getExpected() != null) {
                int expectedEntryIndex = 1;
                jsonWriter.key("Expected").object();
                for (Map.Entry<String, ExpectedAttributeValue> expectedListValue : deleteItemRequest.getExpected().entrySet()) {
                    AttributeValue attributeValueValue;
                    jsonWriter.key(expectedListValue.getKey());
                    jsonWriter.object();
                    if (expectedListValue.getValue() != null && (attributeValueValue = expectedListValue.getValue().getValue()) != null) {
                        jsonWriter.key("Value").object();
                        if (attributeValueValue.getS() != null) {
                            jsonWriter.key("S").value(attributeValueValue.getS());
                        }
                        if (attributeValueValue.getN() != null) {
                            jsonWriter.key("N").value(attributeValueValue.getN());
                        }
                        if (attributeValueValue != null) {
                            List<String> sSList = attributeValueValue.getSS();
                            int sSListIndex = 0;
                            if (sSList != null && sSList.size() > 0) {
                                jsonWriter.key("SS").array();
                                for (String sSListValue : sSList) {
                                    if (sSListValue != null) {
                                        jsonWriter.value(sSListValue);
                                    } else {
                                        jsonWriter.value(null);
                                    }
                                    ++sSListIndex;
                                }
                                jsonWriter.endArray();
                            }
                        }
                        if (attributeValueValue != null) {
                            List<String> nSList = attributeValueValue.getNS();
                            int nSListIndex = 0;
                            if (nSList != null && nSList.size() > 0) {
                                jsonWriter.key("NS").array();
                                for (String nSListValue : nSList) {
                                    if (nSListValue != null) {
                                        jsonWriter.value(nSListValue);
                                    } else {
                                        jsonWriter.value(null);
                                    }
                                    ++nSListIndex;
                                }
                                jsonWriter.endArray();
                            }
                        }
                        jsonWriter.endObject();
                    }
                    if (expectedListValue.getValue().isExists() != null) {
                        jsonWriter.key("Exists").value(expectedListValue.getValue().isExists());
                    }
                    jsonWriter.endObject();
                    ++expectedEntryIndex;
                }
                jsonWriter.endObject();
            }
            if (deleteItemRequest.getReturnValues() != null) {
                jsonWriter.key("ReturnValues").value(deleteItemRequest.getReturnValues());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes("UTF-8");
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            return request;
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }
}

