/*
 * Decompiled with CFR 0.152.
 */
package com.norbl.util.ssh;

import ch.ethz.ssh2.Connection;
import ch.ethz.ssh2.Session;
import com.norbl.cbp.ppe.ConstantsEc2;
import com.norbl.cbp.ppe.ParamHtPPE;
import com.norbl.cbp.ppe.ParamsEc2;
import com.norbl.util.gui.GuiMetrics;
import com.norbl.util.gui.GuiUtil;
import com.norbl.util.gui.SwingDefaults;
import com.norbl.util.ssh.Ssh;
import com.norbl.util.ssh.SshMinimalShellFrame;
import java.awt.EventQueue;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class SshMinimalShell {
    protected Connection connection;
    protected Session session;
    StdReader stdout;
    StdReader stderr;
    BufW stdin;
    SshMinimalShellFrame frame;
    StdinHandler stdinHandler;
    static int MAX_HIST = 1000;
    public static String helpTT = "<html><div width=400><br>This is an admittedly minimal ssh shell. Enter commands in the 'stdin' area and terminate them with newline - the results will be displayed in 'stdout' and 'stderr' <br><br>There is a simple history mechanism: in stdin you can use the up and down arrow keys to retrieve commands.<br><br>When you launch this shell, you are logged in as ec2-user, but you can use su or sudo (neither require a password).<br><br>And of course for a <i>real</i> shell you can always connect to any of your instances with ssh, i.e.<blockquote>ssh -i &lt;pem file&gt; ec2-user@&lt;Public DNS (hostName)&gt;</blockquote>where &lt;pem file&gt; is the local file that contains your keypair.<br><br></div></html>";

    public SshMinimalShell(Connection connection) {
        this.connection = connection;
    }

    public void connect() throws Exception {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                SshMinimalShell.this.frame = new SshMinimalShellFrame(SshMinimalShell.this.connection.getHostname(), SshMinimalShell.this);
                SshMinimalShell.this.frame.appendOutput("Connecting to " + SshMinimalShell.this.connection.getHostname() + "\n");
            }
        });
        this.session = this.connection.openSession();
        this.session.requestPTY("dumb");
        this.session.startShell();
        this.stdin = new BufW(this.session.getStdin());
        this.stdout = new StdReader(this.session.getStdout());
        this.stderr = new StdReader(this.session.getStderr());
        this.stdinHandler = new StdinHandler();
        while (this.frame == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.frame.getStdinDoc().addDocumentListener(this.stdinHandler);
        this.frame.setInputKeyListener(this.stdinHandler);
        new Thread(this.stdout).start();
    }

    void sendCmd(String c) throws Exception {
        this.stdin.writeLine(c);
    }

    public void shutdown() {
        if (this.stdout != null) {
            this.stdout.close();
        }
        if (this.stdin != null) {
            this.stdin.close();
        }
        if (this.stderr != null) {
            this.stderr.close();
        }
        if (this.session != null) {
            this.session.close();
        }
        if (this.connection != null) {
            this.connection.close();
        }
    }

    public static void main(String[] argv) throws Exception {
        SwingDefaults.setDefaults();
        GuiMetrics.init();
        String cf = "/home/moi/eh/aws/nbl_account/nbl.ppe-config";
        ParamHtPPE pht = new ParamHtPPE(new String[]{"configFile=" + cf});
        ParamsEc2 pe2 = new ParamsEc2(pht);
        System.out.println("Connecting " + pe2.rsaKeyPairFile);
        Connection con = Ssh.connect("ec2-107-21-74-147.compute-1.amazonaws.com", ConstantsEc2.EC2_USERNAME, pe2.rsaKeyPairFile, 600000L);
        System.out.println("Connected");
        SshMinimalShell st = new SshMinimalShell(con);
        st.connect();
        System.out.println("Session connected");
        while (true) {
            try {
                while (true) {
                    Thread.sleep(1000L);
                }
            }
            catch (InterruptedException ix) {
                continue;
            }
            break;
        }
    }

    class StdinHandler
    implements DocumentListener,
    KeyListener {
        List<String> cmdHistory = new ArrayList<String>();
        int idxHistory = this.cmdHistory.size();

        @Override
        public void insertUpdate(DocumentEvent de) {
            try {
                String line;
                final Document doc = de.getDocument();
                String s = doc.getText(doc.getLength() - 1, 1);
                if (s.contains("\n") && (line = this.getLastLine(doc)) != null && line.length() > 0) {
                    SshMinimalShell.this.sendCmd(line);
                    this.cmdHistory.add(line);
                    if (this.cmdHistory.size() > MAX_HIST) {
                        for (int i = 0; i < 100; ++i) {
                            this.cmdHistory.remove(0);
                        }
                    }
                    this.idxHistory = this.cmdHistory.size();
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                doc.remove(0, doc.getLength());
                            }
                            catch (Exception zzz) {
                                GuiUtil.exceptionMessage(zzz);
                            }
                        }
                    });
                }
            }
            catch (Exception xxx) {
                GuiUtil.exceptionMessage(xxx);
            }
        }

        @Override
        public void removeUpdate(DocumentEvent de) {
        }

        @Override
        public void changedUpdate(DocumentEvent de) {
        }

        String getLastLine(Document doc) throws Exception {
            int n = doc.getLength();
            if (n < 2) {
                return null;
            }
            String s = doc.getText(0, n);
            int i0 = this.getStartOfLastLine(s, n);
            return s.substring(i0);
        }

        int getStartOfLastLine(String s, int lineLen) {
            for (int i = lineLen - 2; i >= 0; --i) {
                if (s.charAt(i) != '\n') continue;
                return i + 1;
            }
            return 0;
        }

        @Override
        public void keyReleased(KeyEvent ke) {
            int keyCode = ke.getKeyCode();
            switch (keyCode) {
                case 38: {
                    this.showHistUp();
                    break;
                }
                case 40: {
                    this.showHistDown();
                    break;
                }
            }
        }

        void showHistUp() {
            if (this.idxHistory - 1 < 0) {
                return;
            }
            --this.idxHistory;
            if (this.idxHistory >= this.cmdHistory.size()) {
                return;
            }
            String hc = this.cmdHistory.get(this.idxHistory);
            this.showAsInput(hc);
        }

        void showHistDown() {
            if (this.idxHistory + 1 >= this.cmdHistory.size()) {
                return;
            }
            ++this.idxHistory;
            String hc = this.cmdHistory.get(this.idxHistory);
            this.showAsInput(hc);
        }

        void showAsInput(final String hc) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        Document doc = SshMinimalShell.this.frame.getStdinDoc();
                        doc.remove(0, doc.getLength());
                        SshMinimalShell.this.frame.appendToStdin(hc.replace('\n', ' ').trim());
                    }
                    catch (Exception xxx) {
                        GuiUtil.exceptionMessage(xxx);
                    }
                }
            });
        }

        @Override
        public void keyPressed(KeyEvent ke) {
        }

        @Override
        public void keyTyped(KeyEvent ke) {
        }
    }

    class BufW {
        OutputStreamWriter ow;
        BufferedOutputStream b;

        BufW(OutputStream ous) {
            this.b = new BufferedOutputStream(ous);
            this.ow = new OutputStreamWriter(this.b);
        }

        void writeLine(String s) throws Exception {
            this.ow.write(s, 0, s.length());
            this.ow.flush();
        }

        void close() {
            try {
                if (this.b != null) {
                    this.b.close();
                }
                if (this.ow != null) {
                    this.ow.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    class StdReader
    implements Runnable {
        InputStream ins;
        InputStreamReader r;
        boolean keepRunning;

        StdReader(InputStream ins) {
            this.ins = ins;
            this.r = new InputStreamReader(ins);
            this.keepRunning = true;
        }

        @Override
        public void run() {
            try {
                while (this.keepRunning) {
                    SshMinimalShell.this.frame.appendOutput(Character.toString((char)this.r.read()));
                }
            }
            catch (Exception xxx) {
                GuiUtil.exceptionMessage(xxx);
                this.keepRunning = false;
                return;
            }
        }

        void close() {
            try {
                this.keepRunning = false;
                if (this.r != null) {
                    this.r.close();
                }
                if (this.ins != null) {
                    this.ins.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

