/*
 * Decompiled with CFR 0.152.
 */
package com.norbl.util.http;

import com.norbl.util.http.URIObj;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ServerSocket;
import java.net.Socket;
import org.apache.http.ConnectionClosedException;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseFactory;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.HttpServerConnection;
import org.apache.http.impl.DefaultConnectionReuseStrategy;
import org.apache.http.impl.DefaultHttpResponseFactory;
import org.apache.http.impl.DefaultHttpServerConnection;
import org.apache.http.params.HttpParams;
import org.apache.http.params.SyncBasicHttpParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.HttpRequestHandler;
import org.apache.http.protocol.HttpRequestHandlerRegistry;
import org.apache.http.protocol.HttpRequestHandlerResolver;
import org.apache.http.protocol.HttpService;
import org.apache.http.protocol.ImmutableHttpProcessor;
import org.apache.http.protocol.ResponseConnControl;
import org.apache.http.protocol.ResponseContent;
import org.apache.http.protocol.ResponseDate;
import org.apache.http.protocol.ResponseServer;

public class SimpleHttpServer {
    public static void main(String[] args) throws Exception {
        ReqListenerThread t = new ReqListenerThread(new ReqHandler(), 80);
        t.setDaemon(false);
        t.start();
    }

    public static class ReqHandler
    implements HttpRequestHandler {
        public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
            URIObj uio = new URIObj(request.getRequestLine().getUri());
            System.out.println("---------------------------------------------\nresponse=\n" + response + "\n" + "context=\n" + context + "\n" + "line method=\n" + request.getRequestLine().getMethod() + "\n" + "line uri=\n" + uio + "\n" + "---------------------------------------------\n");
        }
    }

    static class WorkerThread
    extends Thread {
        private final HttpService httpservice;
        private final HttpServerConnection conn;

        public WorkerThread(HttpService httpservice, HttpServerConnection conn) {
            this.httpservice = httpservice;
            this.conn = conn;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            System.out.println("New connection thread");
            BasicHttpContext context = new BasicHttpContext(null);
            try {
                while (!Thread.interrupted() && this.conn.isOpen()) {
                    this.httpservice.handleRequest(this.conn, (HttpContext)context);
                }
            }
            catch (ConnectionClosedException ex) {
                System.err.println("Client closed connection");
            }
            catch (IOException ex) {
                System.err.println("I/O error: " + ex.getMessage());
            }
            catch (HttpException ex) {
                System.err.println("Unrecoverable HTTP protocol violation: " + ex.getMessage());
            }
            finally {
                try {
                    this.conn.shutdown();
                }
                catch (IOException ignore) {}
            }
        }
    }

    public static class ReqListenerThread
    extends Thread {
        private final ServerSocket serversocket;
        private final HttpParams params;
        private final HttpService httpService;
        private final HttpRequestHandler reqHandler;

        public ReqListenerThread(HttpRequestHandler reqHandler, int port) throws IOException {
            this.reqHandler = reqHandler;
            this.serversocket = new ServerSocket(port);
            this.params = new SyncBasicHttpParams();
            this.params.setIntParameter("http.socket.timeout", 5000).setIntParameter("http.socket.buffer-size", 8192).setBooleanParameter("http.connection.stalecheck", false).setBooleanParameter("http.tcp.nodelay", true).setParameter("http.origin-server", (Object)"HttpComponents/1.1");
            ImmutableHttpProcessor httpproc = new ImmutableHttpProcessor(new HttpResponseInterceptor[]{new ResponseDate(), new ResponseServer(), new ResponseContent(), new ResponseConnControl()});
            HttpRequestHandlerRegistry reqistry = new HttpRequestHandlerRegistry();
            reqistry.register("*", reqHandler);
            this.httpService = new HttpService((HttpProcessor)httpproc, (ConnectionReuseStrategy)new DefaultConnectionReuseStrategy(), (HttpResponseFactory)new DefaultHttpResponseFactory(), (HttpRequestHandlerResolver)reqistry, this.params);
        }

        @Override
        public void run() {
            System.out.println("SimpleHttpServer listening on port " + this.serversocket.getLocalPort());
            while (!Thread.interrupted()) {
                try {
                    Socket socket = this.serversocket.accept();
                    DefaultHttpServerConnection conn = new DefaultHttpServerConnection();
                    System.out.println("Incoming connection from " + socket.getInetAddress());
                    conn.bind(socket, this.params);
                    WorkerThread t = new WorkerThread(this.httpService, (HttpServerConnection)conn);
                    t.setDaemon(true);
                    t.setPriority(1);
                    t.start();
                }
                catch (InterruptedIOException ex) {
                    break;
                }
                catch (IOException e) {
                    System.err.println("I/O error initialising connection thread: " + e.getMessage());
                    break;
                }
            }
        }
    }
}

