/*
 * Decompiled with CFR 0.152.
 */
package ppe.gui.networkspec;

import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;
import ppe.gui.networkspec.Choice;

public class ChoiceSet
extends ArrayList<Choice> {
    ButtonGroup buttonGroup;

    public boolean hasChoiceType(String choiceType) {
        if (this.size() < 1) {
            return false;
        }
        return choiceType.equals(((Choice)this.get(0)).getClass().getSimpleName());
    }

    public void createButtonGroup() {
        this.buttonGroup = new ButtonGroup();
        for (Choice c : this) {
            JRadioButton b = c.cc.getRadioButton();
            if (b == null) continue;
            this.buttonGroup.add(b);
        }
    }

    public Choice getChoice(String label) {
        for (Choice c : this) {
            if (!c.getLabel().equals(label)) continue;
            return c;
        }
        throw new RuntimeException("No choice matches label=" + label);
    }

    public Choice getChoiceOrNull(String label) {
        for (Choice c : this) {
            if (!c.getLabel().equals(label)) continue;
            return c;
        }
        return null;
    }

    public Choice getSelected() {
        for (Choice c : this) {
            if (!c.selected) continue;
            return c;
        }
        return null;
    }

    public int getNColumns() {
        int n0 = ((Choice)this.get(0)).getNColumns();
        for (int i = 1; i < this.size(); ++i) {
            if (((Choice)this.get(i)).getNColumns() == n0) continue;
            throw new RuntimeException("ChoiseSet n column mismatch for " + ((Choice)this.get(0)).getClass().getName());
        }
        return n0;
    }
}

