% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gregorian-year-month-day.R
\name{year-month-day-group}
\alias{year-month-day-group}
\alias{calendar_group.clock_year_month_day}
\title{Grouping: year-month-day}
\usage{
\method{calendar_group}{clock_year_month_day}(x, precision, ..., n = 1L)
}
\arguments{
\item{x}{\verb{[clock_year_month_day]}

A year-month-day vector.}

\item{precision}{\verb{[character(1)]}

One of:
\itemize{
\item \code{"year"}
\item \code{"month"}
\item \code{"day"}
\item \code{"hour"}
\item \code{"minute"}
\item \code{"second"}
\item \code{"millisecond"}
\item \code{"microsecond"}
\item \code{"nanosecond"}
}}

\item{...}{These dots are for future extensions and must be empty.}

\item{n}{\verb{[positive integer(1)]}

A single positive integer specifying a multiple of \code{precision} to use.}
}
\value{
\code{x} grouped at the specified \code{precision}.
}
\description{
This is a year-month-day method for the \code{\link[=calendar_group]{calendar_group()}} generic.

Grouping for a year-month-day object can be done at any precision, as
long as \code{x} is at least as precise as \code{precision}.
}
\examples{
steps <- duration_days(seq(0, 100, by = 5))
x <- year_month_day(2019, 1, 1)
x <- as_naive_time(x) + steps
x <- as_year_month_day(x)
x

# Group by a single month
calendar_group(x, "month")

# Or multiple months
calendar_group(x, "month", n = 2)

# Group 3 days of the month together
y <- year_month_day(2019, 1, 1:12)
calendar_group(y, "day", n = 3)

# Group by 5 nanosecond of the current second
z <- year_month_day(
  2019, 1, 2, 1, 5, 20, 1:20,
  subsecond_precision = "nanosecond"
)
calendar_group(z, "nanosecond", n = 5)
}
