% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/links.R
\name{link_functions}
\alias{link_functions}
\title{Available Link Functions}
\description{
clmstan supports the following link functions for cumulative link models:

\strong{Standard links (no additional parameters):}
\itemize{
\item \code{"logit"} - Logistic (proportional odds model)
\item \code{"probit"} - Normal (latent variable interpretation)
\item \code{"cloglog"} - Complementary log-log (proportional hazards)
\item \code{"loglog"} - Log-log (Gumbel minimum)
\item \code{"cauchit"} - Cauchy (heavy tails)
}

\strong{Flexible links (with additional parameters):}
\itemize{
\item \code{"tlink"} - Student-t (df > 0)
\itemize{
\item df = Inf: equals probit
\item df < 3: increasingly heavy tails; df > 30 is nearly normal
}
\item \code{"aranda_ordaz"} - Aranda-Ordaz asymmetric (lambda > 0)
\itemize{
\item lambda = 1: equals logit
\item lambda -> 0: approaches cloglog
}
\item \code{"gev"} - Generalized extreme value (shape parameter xi)
\itemize{
\item xi = 0: Gumbel (equals loglog)
\item xi < 0: Weibull (short tail)
\item xi > 0: Frechet (heavy tail)
}
\item \code{"sp"} - Symmetric power (r > 0, base distribution)
\itemize{
\item r = 1: equals base distribution
\item 0 < r < 1: positively skewed
\item r > 1: negatively skewed
}
\item \code{"log_gamma"} - Log-gamma (lambda)
\itemize{
\item lambda = 0: equals probit
\item lambda > 0 or < 0: asymmetric
}
\item \code{"aep"} - Asymmetric exponential power (theta1 > 0, theta2 > 0)
\itemize{
\item alpha = 0.5 fixed for identifiability
\item theta1 = theta2: symmetric distribution
\item theta = 2: Gaussian kernel (but NOT equal to probit due to scaling)
\item theta < 2: heavy tails (leptokurtic)
\item theta > 2: light tails (platykurtic)
}
}
}
\section{Link Parameter Specification}{

Flexible link parameters can be either \strong{fixed} or \strong{estimated} (inferred).

\strong{Fixed parameters:} Specify a numeric value

\if{html}{\out{<div class="sourceCode">}}\preformatted{clm_stan(y ~ x, link = "tlink", link_param = list(df = 8))
clm_stan(y ~ x, link = "gev", link_param = list(xi = 0))  # equals loglog
clm_stan(y ~ x, link = "aep", link_param = list(theta1 = 2, theta2 = 2))  # symmetric
}\if{html}{\out{</div>}}

\strong{Estimated parameters:} Use \code{"estimate"} (with default prior)

\if{html}{\out{<div class="sourceCode">}}\preformatted{clm_stan(y ~ x, link = "tlink", link_param = list(df = "estimate"))
clm_stan(y ~ x, link = "gev", link_param = list(xi = "estimate"))
}\if{html}{\out{</div>}}

\strong{Custom priors:} Combine \code{"estimate"} with \code{prior} argument

\if{html}{\out{<div class="sourceCode">}}\preformatted{clm_stan(y ~ x, link = "gev",
         link_param = list(xi = "estimate"),
         prior = prior(normal(0, 0.3), class = "xi"))
}\if{html}{\out{</div>}}
}

\section{Default Priors for Link Parameters}{

When using \code{"estimate"}, the following default priors are used:\tabular{llll}{
   Link \tab Parameter \tab Default Prior \tab Notes \cr
   tlink \tab df \tab gamma(2, 0.1) \tab Mode around 10, allows heavy tails \cr
   aranda_ordaz \tab lambda \tab gamma(0.5, 0.5) \tab Centered near 1 (logit) \cr
   gev \tab xi \tab normal(0, 2) \tab Weakly informative, Wang & Dey (2011) \cr
   sp \tab r \tab gamma(0.5, 0.5) \tab Centered near 1 (base distribution) \cr
   log_gamma \tab lambda \tab normal(0, 1) \tab Centered at 0 (probit) \cr
   aep \tab theta1 \tab gamma(2, 1) \tab Mode at 1, symmetric at theta1=theta2 \cr
   aep \tab theta2 \tab gamma(2, 1) \tab Mode at 1, symmetric at theta1=theta2 \cr
}
}

\section{SP Link Details (Li et al., 2019)}{

The Symmetric Power link uses a symmetric base distribution F_0,
specified via the \code{base} argument. Supported bases:
\itemize{
\item \code{base = "logit"}: Logistic base (default)
\item \code{base = "probit"}: Normal base
\item \code{base = "cauchit"}: Cauchy base
\item \code{base = "tlink"}: Student-t base (requires df)
}

Note: Li et al. (2019) define F_0 as a CDF "whose corresponding PDF is
symmetric about 0".
}

\concept{link functions}
